extends AudioEffect
class_name AudioEffectRecord

## Audio effect used for recording the sound from an audio bus.
##
## Allows the user to record the sound from an audio bus into an [AudioStreamWAV]. When used on the "Master" audio bus, this includes all audio output by Godot.
## Unlike [AudioEffectCapture], this effect encodes the recording with the given format (8-bit, 16-bit, or compressed) instead of giving access to the raw audio samples.
## Can be used (with an [AudioStreamMicrophone]) to record from a microphone.
## [b]Note:[/b] [member ProjectSettings.audio/driver/enable_input] must be [code]true[/code] for audio input to work. See also that setting's description for caveats related to permissions and operating system privacy settings.
##
## @tutorial(Recording with microphone): https://docs.godotengine.org/en/stable/tutorials/audio/recording_with_microphone.html
## @tutorial(Audio Microphone Record Demo): https://godotengine.org/asset-library/asset/2760



## Specifies the format in which the sample will be recorded.
var format: int:
	get = get_format, set = set_format



## Returns the recorded sample.
func get_recording() -> AudioStreamWAV:
	pass;

## Returns whether the recording is active or not.
func is_recording_active() -> bool:
	pass;

## If [code]true[/code], the sound will be recorded. Note that restarting the recording will remove the previously recorded sample.
func set_recording_active(record: bool) -> void:
	pass;


func get_format() -> int:
	return format

func set_format(value: int) -> void:
	format = value

