extends AudioEffect
class_name AudioEffectAmplify

## Adds an amplifying audio effect to an audio bus.
##
## Increases or decreases the volume being routed through the audio bus.
##
## @tutorial(Audio buses): https://docs.godotengine.org/en/stable/tutorials/audio/audio_buses.html



## Amount of amplification in decibels. Positive values make the sound louder, negative values make it quieter. Value can range from -80 to 24.
var volume_db: float:
	get = get_volume_db, set = set_volume_db

## Amount of amplification as a linear value.
## [b]Note:[/b] This member modifies [member volume_db] for convenience. The returned value is equivalent to the result of [method @GlobalScope.db_to_linear] on [member volume_db]. Setting this member is equivalent to setting [member volume_db] to the result of [method @GlobalScope.linear_to_db] on a value.
var volume_linear: float:
	get = get_volume_linear, set = set_volume_linear




func get_volume_db() -> float:
	return volume_db

func set_volume_db(value: float) -> void:
	volume_db = value

func get_volume_linear() -> float:
	return volume_linear

func set_volume_linear(value: float) -> void:
	volume_linear = value

