extends AnimationRootNode
class_name AnimationNodeBlendTree

## A sub-tree of many type [AnimationNode]s used for complex animations. Used by [AnimationTree].
##
## This animation node may contain a sub-tree of any other type animation nodes, such as [AnimationNodeTransition], [AnimationNodeBlend2], [AnimationNodeBlend3], [AnimationNodeOneShot], etc. This is one of the most commonly used animation node roots.
## An [AnimationNodeOutput] node named [code]output[/code] is created by default.
##
## @tutorial(Using AnimationTree): https://docs.godotengine.org/en/stable/tutorials/animation/animation_tree.html


## Emitted when the input port information is changed.
signal node_changed(node_name: StringName)
## The connection was successful.
const CONNECTION_OK = 0;

## The input node is [code]null[/code].
const CONNECTION_ERROR_NO_INPUT = 1;

## The specified input port is out of range.
const CONNECTION_ERROR_NO_INPUT_INDEX = 2;

## The output node is [code]null[/code].
const CONNECTION_ERROR_NO_OUTPUT = 3;

## Input and output nodes are the same.
const CONNECTION_ERROR_SAME_NODE = 4;

## The specified connection already exists.
const CONNECTION_ERROR_CONNECTION_EXISTS = 5;


## The global offset of all sub animation nodes.
var graph_offset: Vector2:
	get = get_graph_offset, set = set_graph_offset



## Adds an [AnimationNode] at the given [param position]. The [param name] is used to identify the created sub animation node later.
func add_node(name: StringName, node: AnimationNode, position: Vector2 = Vector2(0, 0)) -> void:
	pass;

## Connects the output of an [AnimationNode] as input for another [AnimationNode], at the input port specified by [param input_index].
func connect_node(input_node: StringName, input_index: int, output_node: StringName) -> void:
	pass;

## Disconnects the animation node connected to the specified input.
func disconnect_node(input_node: StringName, input_index: int) -> void:
	pass;

## Returns the sub animation node with the specified [param name].
func get_node(name: StringName) -> AnimationNode:
	pass;

## Returns a list containing the names of all sub animation nodes in this blend tree.
func get_node_list() -> Array[StringName]:
	pass;

## Returns the position of the sub animation node with the specified [param name].
func get_node_position(name: StringName) -> Vector2:
	pass;

## Returns [code]true[/code] if a sub animation node with specified [param name] exists.
func has_node(name: StringName) -> bool:
	pass;

## Removes a sub animation node.
func remove_node(name: StringName) -> void:
	pass;

## Changes the name of a sub animation node.
func rename_node(name: StringName, new_name: StringName) -> void:
	pass;

## Modifies the position of a sub animation node.
func set_node_position(name: StringName, position: Vector2) -> void:
	pass;


func get_graph_offset() -> Vector2:
	return graph_offset

func set_graph_offset(value: Vector2) -> void:
	graph_offset = value

