extends BoneConstraint3D
class_name AimModifier3D

## The [AimModifier3D] rotates a bone to look at a reference bone.
##
## This is a simple version of [LookAtModifier3D] that only allows bone to the reference without advanced options such as angle limitation or time-based interpolation.
## The feature is simplified, but instead it is implemented with smooth tracking without euler, see [method set_use_euler].



## The number of settings in the modifier.
var setting_count: int:
	get = get_setting_count, set = set_setting_count



## Returns the forward axis of the bone.
func get_forward_axis(index: int) -> int:
	pass;

## Returns the axis of the first rotation. It is enabled only if [method is_using_euler] is [code]true[/code].
func get_primary_rotation_axis(index: int) -> int:
	pass;

## Returns [code]true[/code] if it provides rotation with using euler.
func is_using_euler(index: int) -> bool:
	pass;

## Returns [code]true[/code] if it provides rotation by two axes. It is enabled only if [method is_using_euler] is [code]true[/code].
func is_using_secondary_rotation(index: int) -> bool:
	pass;

## Sets the forward axis of the bone.
func set_forward_axis(index: int, axis: int) -> void:
	pass;

## Sets the axis of the first rotation. It is enabled only if [method is_using_euler] is [code]true[/code].
func set_primary_rotation_axis(index: int, axis: int) -> void:
	pass;

## If sets [param enabled] to [code]true[/code], it provides rotation with using euler.
## If sets [param enabled] to [code]false[/code], it provides rotation with using rotation by arc generated from the forward axis vector and the vector toward the reference.
func set_use_euler(index: int, enabled: bool) -> void:
	pass;

## If sets [param enabled] to [code]true[/code], it provides rotation by two axes. It is enabled only if [method is_using_euler] is [code]true[/code].
func set_use_secondary_rotation(index: int, enabled: bool) -> void:
	pass;


func get_setting_count() -> int:
	return setting_count

func set_setting_count(value: int) -> void:
	setting_count = value

