extends Node3D
class_name XRNode3D

## A 3D node that has its position automatically updated by the [XRServer].
##
## This node can be bound to a specific pose of a [XRPositionalTracker] and will automatically have its [member Node3D.transform] updated by the [XRServer]. Nodes of this type must be added as children of the [XROrigin3D] node.
##
## @tutorial(XR documentation index): https://docs.godotengine.org/en/stable/tutorials/xr/index.html


## Emitted when the [member tracker] starts or stops receiving updated tracking data for the [member pose] being tracked. The [param tracking] argument indicates whether the tracker is getting updated tracking data.
signal tracking_changed(tracking: bool)

## The name of the pose we're bound to. Which poses a tracker supports is not known during design time.
## Godot defines number of standard pose names such as [code]aim[/code] and [code]grip[/code] but other may be configured within a given [XRInterface].
var pose: StringName:
	get = get_pose_name, set = set_pose_name

## Enables showing the node when tracking starts, and hiding the node when tracking is lost.
var show_when_tracked: bool:
	get = get_show_when_tracked, set = set_show_when_tracked

## The name of the tracker we're bound to. Which trackers are available is not known during design time.
## Godot defines a number of standard trackers such as [code]left_hand[/code] and [code]right_hand[/code] but others may be configured within a given [XRInterface].
var tracker: StringName:
	get = get_tracker, set = set_tracker



## Returns [code]true[/code] if the [member tracker] has current tracking data for the [member pose] being tracked.
func get_has_tracking_data() -> bool:
	pass;

## Returns [code]true[/code] if the [member tracker] has been registered and the [member pose] is being tracked.
func get_is_active() -> bool:
	pass;

## Returns the [XRPose] containing the current state of the pose being tracked. This gives access to additional properties of this pose.
func get_pose() -> XRPose:
	pass;

## Triggers a haptic pulse on a device associated with this interface.
## [param action_name] is the name of the action for this pulse.
## [param frequency] is the frequency of the pulse, set to [code]0.0[/code] to have the system use a default frequency.
## [param amplitude] is the amplitude of the pulse between [code]0.0[/code] and [code]1.0[/code].
## [param duration_sec] is the duration of the pulse in seconds.
## [param delay_sec] is a delay in seconds before the pulse is given.
func trigger_haptic_pulse(action_name: String, frequency: float, amplitude: float, duration_sec: float, delay_sec: float) -> void:
	pass;


func get_pose_name() -> StringName:
	return pose

func set_pose_name(value: StringName) -> void:
	pose = value

func get_show_when_tracked() -> bool:
	return show_when_tracked

func set_show_when_tracked(value: bool) -> void:
	show_when_tracked = value

func get_tracker() -> StringName:
	return tracker

func set_tracker(value: StringName) -> void:
	tracker = value

