extends XRTracker
class_name XRFaceTracker

## A tracked face.
##
## An instance of this object represents a tracked face and its corresponding blend shapes. The blend shapes come from the [url=https://docs.vrcft.io/docs/tutorial-avatars/tutorial-avatars-extras/unified-blendshapes]Unified Expressions[/url] standard, and contain extended details and visuals for each blend shape. Additionally the [url=https://docs.vrcft.io/docs/tutorial-avatars/tutorial-avatars-extras/compatibility/overview]Tracking Standard Comparison[/url] page documents the relationship between Unified Expressions and other standards.
## As face trackers are turned on they are registered with the [XRServer].
##
## @tutorial(XR documentation index): https://docs.godotengine.org/en/stable/tutorials/xr/index.html


## Right eye looks outwards.
## Right eye looks inwards.
## Right eye looks upwards.
## Right eye looks downwards.
## Left eye looks outwards.
## Left eye looks inwards.
## Left eye looks upwards.
## Left eye looks downwards.
## Closes the right eyelid.
## Closes the left eyelid.
## Squeezes the right eye socket muscles.
## Squeezes the left eye socket muscles.
## Right eyelid widens beyond relaxed.
## Left eyelid widens beyond relaxed.
## Dilates the right eye pupil.
## Dilates the left eye pupil.
## Constricts the right eye pupil.
## Constricts the left eye pupil.
## Right eyebrow pinches in.
## Left eyebrow pinches in.
## Outer right eyebrow pulls down.
## Outer left eyebrow pulls down.
## Inner right eyebrow pulls up.
## Inner left eyebrow pulls up.
## Outer right eyebrow pulls up.
## Outer left eyebrow pulls up.
## Right side face sneers.
## Left side face sneers.
## Right side nose canal dilates.
## Left side nose canal dilates.
## Right side nose canal constricts.
## Left side nose canal constricts.
## Raises the right side cheek.
## Raises the left side cheek.
## Puffs the right side cheek.
## Puffs the left side cheek.
## Sucks in the right side cheek.
## Sucks in the left side cheek.
## Opens jawbone.
## Closes the mouth.
## Pushes jawbone right.
## Pushes jawbone left.
## Pushes jawbone forward.
## Pushes jawbone backward.
## Flexes jaw muscles.
## Raises the jawbone.
## Upper right lip part tucks in the mouth.
## Upper left lip part tucks in the mouth.
## Lower right lip part tucks in the mouth.
## Lower left lip part tucks in the mouth.
## Right lip corner folds into the mouth.
## Left lip corner folds into the mouth.
## Upper right lip part pushes into a funnel.
## Upper left lip part pushes into a funnel.
## Lower right lip part pushes into a funnel.
## Lower left lip part pushes into a funnel.
## Upper right lip part pushes outwards.
## Upper left lip part pushes outwards.
## Lower right lip part pushes outwards.
## Lower left lip part pushes outwards.
## Upper right part of the lip pulls up.
## Upper left part of the lip pulls up.
## Lower right part of the lip pulls up.
## Lower left part of the lip pulls up.
## Upper right lip part pushes in the cheek.
## Upper left lip part pushes in the cheek.
## Moves upper lip right.
## Moves upper lip left.
## Moves lower lip right.
## Moves lower lip left.
## Right lip corner pulls diagonally up and out.
## Left lip corner pulls diagonally up and out.
## Right corner lip slants up.
## Left corner lip slants up.
## Right corner lip pulls down.
## Left corner lip pulls down.
## Mouth corner lip pulls out and down.
## Mouth corner lip pulls out and down.
## Right lip corner is pushed backwards.
## Left lip corner is pushed backwards.
## Raises and slightly pushes out the upper mouth.
## Raises and slightly pushes out the lower mouth.
## Right side lips press and flatten together vertically.
## Left side lips press and flatten together vertically.
## Right side lips squeeze together horizontally.
## Left side lips squeeze together horizontally.
## Tongue visibly sticks out of the mouth.
## Tongue points upwards.
## Tongue points downwards.
## Tongue points right.
## Tongue points left.
## Sides of the tongue funnel, creating a roll.
## Tongue arches up then down inside the mouth.
## Tongue arches down then up inside the mouth.
## Tongue squishes together and thickens.
## Tongue flattens and thins out.
## Tongue tip rotates clockwise, with the rest following gradually.
## Tongue tip rotates counter-clockwise, with the rest following gradually.
## Inner mouth throat closes.
## The Adam's apple visibly swallows.
## Right side neck visibly flexes.
## Left side neck visibly flexes.
## Closes both eye lids.
## Widens both eye lids.
## Squints both eye lids.
## Dilates both pupils.
## Constricts both pupils.
## Pulls the right eyebrow down and in.
## Pulls the left eyebrow down and in.
## Pulls both eyebrows down and in.
## Right brow appears worried.
## Left brow appears worried.
## Both brows appear worried.
## Entire face sneers.
## Both nose canals dilate.
## Both nose canals constrict.
## Puffs both cheeks.
## Sucks in both cheeks.
## Raises both cheeks.
## Tucks in the upper lips.
## Tucks in the lower lips.
## Tucks in both lips.
## Funnels in the upper lips.
## Funnels in the lower lips.
## Funnels in both lips.
## Upper lip part pushes outwards.
## Lower lip part pushes outwards.
## Lips push outwards.
## Raises the upper lips.
## Lowers the lower lips.
## Mouth opens, revealing teeth.
## Moves mouth right.
## Moves mouth left.
## Right side of the mouth smiles.
## Left side of the mouth smiles.
## Mouth expresses a smile.
## Right side of the mouth expresses sadness.
## Left side of the mouth expresses sadness.
## Mouth expresses sadness.
## Mouth stretches.
## Lip corners dimple.
## Mouth tightens.
## Mouth presses together.
## Represents the size of the [enum BlendShapeEntry] enum.

#enum BlendShapeEntry
enum {
    FT_EYE_LOOK_OUT_RIGHT = 0,
    FT_EYE_LOOK_IN_RIGHT = 1,
    FT_EYE_LOOK_UP_RIGHT = 2,
    FT_EYE_LOOK_DOWN_RIGHT = 3,
    FT_EYE_LOOK_OUT_LEFT = 4,
    FT_EYE_LOOK_IN_LEFT = 5,
    FT_EYE_LOOK_UP_LEFT = 6,
    FT_EYE_LOOK_DOWN_LEFT = 7,
    FT_EYE_CLOSED_RIGHT = 8,
    FT_EYE_CLOSED_LEFT = 9,
    FT_EYE_SQUINT_RIGHT = 10,
    FT_EYE_SQUINT_LEFT = 11,
    FT_EYE_WIDE_RIGHT = 12,
    FT_EYE_WIDE_LEFT = 13,
    FT_EYE_DILATION_RIGHT = 14,
    FT_EYE_DILATION_LEFT = 15,
    FT_EYE_CONSTRICT_RIGHT = 16,
    FT_EYE_CONSTRICT_LEFT = 17,
    FT_BROW_PINCH_RIGHT = 18,
    FT_BROW_PINCH_LEFT = 19,
    FT_BROW_LOWERER_RIGHT = 20,
    FT_BROW_LOWERER_LEFT = 21,
    FT_BROW_INNER_UP_RIGHT = 22,
    FT_BROW_INNER_UP_LEFT = 23,
    FT_BROW_OUTER_UP_RIGHT = 24,
    FT_BROW_OUTER_UP_LEFT = 25,
    FT_NOSE_SNEER_RIGHT = 26,
    FT_NOSE_SNEER_LEFT = 27,
    FT_NASAL_DILATION_RIGHT = 28,
    FT_NASAL_DILATION_LEFT = 29,
    FT_NASAL_CONSTRICT_RIGHT = 30,
    FT_NASAL_CONSTRICT_LEFT = 31,
    FT_CHEEK_SQUINT_RIGHT = 32,
    FT_CHEEK_SQUINT_LEFT = 33,
    FT_CHEEK_PUFF_RIGHT = 34,
    FT_CHEEK_PUFF_LEFT = 35,
    FT_CHEEK_SUCK_RIGHT = 36,
    FT_CHEEK_SUCK_LEFT = 37,
    FT_JAW_OPEN = 38,
    FT_MOUTH_CLOSED = 39,
    FT_JAW_RIGHT = 40,
    FT_JAW_LEFT = 41,
    FT_JAW_FORWARD = 42,
    FT_JAW_BACKWARD = 43,
    FT_JAW_CLENCH = 44,
    FT_JAW_MANDIBLE_RAISE = 45,
    FT_LIP_SUCK_UPPER_RIGHT = 46,
    FT_LIP_SUCK_UPPER_LEFT = 47,
    FT_LIP_SUCK_LOWER_RIGHT = 48,
    FT_LIP_SUCK_LOWER_LEFT = 49,
    FT_LIP_SUCK_CORNER_RIGHT = 50,
    FT_LIP_SUCK_CORNER_LEFT = 51,
    FT_LIP_FUNNEL_UPPER_RIGHT = 52,
    FT_LIP_FUNNEL_UPPER_LEFT = 53,
    FT_LIP_FUNNEL_LOWER_RIGHT = 54,
    FT_LIP_FUNNEL_LOWER_LEFT = 55,
    FT_LIP_PUCKER_UPPER_RIGHT = 56,
    FT_LIP_PUCKER_UPPER_LEFT = 57,
    FT_LIP_PUCKER_LOWER_RIGHT = 58,
    FT_LIP_PUCKER_LOWER_LEFT = 59,
    FT_MOUTH_UPPER_UP_RIGHT = 60,
    FT_MOUTH_UPPER_UP_LEFT = 61,
    FT_MOUTH_LOWER_DOWN_RIGHT = 62,
    FT_MOUTH_LOWER_DOWN_LEFT = 63,
    FT_MOUTH_UPPER_DEEPEN_RIGHT = 64,
    FT_MOUTH_UPPER_DEEPEN_LEFT = 65,
    FT_MOUTH_UPPER_RIGHT = 66,
    FT_MOUTH_UPPER_LEFT = 67,
    FT_MOUTH_LOWER_RIGHT = 68,
    FT_MOUTH_LOWER_LEFT = 69,
    FT_MOUTH_CORNER_PULL_RIGHT = 70,
    FT_MOUTH_CORNER_PULL_LEFT = 71,
    FT_MOUTH_CORNER_SLANT_RIGHT = 72,
    FT_MOUTH_CORNER_SLANT_LEFT = 73,
    FT_MOUTH_FROWN_RIGHT = 74,
    FT_MOUTH_FROWN_LEFT = 75,
    FT_MOUTH_STRETCH_RIGHT = 76,
    FT_MOUTH_STRETCH_LEFT = 77,
    FT_MOUTH_DIMPLE_RIGHT = 78,
    FT_MOUTH_DIMPLE_LEFT = 79,
    FT_MOUTH_RAISER_UPPER = 80,
    FT_MOUTH_RAISER_LOWER = 81,
    FT_MOUTH_PRESS_RIGHT = 82,
    FT_MOUTH_PRESS_LEFT = 83,
    FT_MOUTH_TIGHTENER_RIGHT = 84,
    FT_MOUTH_TIGHTENER_LEFT = 85,
    FT_TONGUE_OUT = 86,
    FT_TONGUE_UP = 87,
    FT_TONGUE_DOWN = 88,
    FT_TONGUE_RIGHT = 89,
    FT_TONGUE_LEFT = 90,
    FT_TONGUE_ROLL = 91,
    FT_TONGUE_BLEND_DOWN = 92,
    FT_TONGUE_CURL_UP = 93,
    FT_TONGUE_SQUISH = 94,
    FT_TONGUE_FLAT = 95,
    FT_TONGUE_TWIST_RIGHT = 96,
    FT_TONGUE_TWIST_LEFT = 97,
    FT_SOFT_PALATE_CLOSE = 98,
    FT_THROAT_SWALLOW = 99,
    FT_NECK_FLEX_RIGHT = 100,
    FT_NECK_FLEX_LEFT = 101,
    FT_EYE_CLOSED = 102,
    FT_EYE_WIDE = 103,
    FT_EYE_SQUINT = 104,
    FT_EYE_DILATION = 105,
    FT_EYE_CONSTRICT = 106,
    FT_BROW_DOWN_RIGHT = 107,
    FT_BROW_DOWN_LEFT = 108,
    FT_BROW_DOWN = 109,
    FT_BROW_UP_RIGHT = 110,
    FT_BROW_UP_LEFT = 111,
    FT_BROW_UP = 112,
    FT_NOSE_SNEER = 113,
    FT_NASAL_DILATION = 114,
    FT_NASAL_CONSTRICT = 115,
    FT_CHEEK_PUFF = 116,
    FT_CHEEK_SUCK = 117,
    FT_CHEEK_SQUINT = 118,
    FT_LIP_SUCK_UPPER = 119,
    FT_LIP_SUCK_LOWER = 120,
    FT_LIP_SUCK = 121,
    FT_LIP_FUNNEL_UPPER = 122,
    FT_LIP_FUNNEL_LOWER = 123,
    FT_LIP_FUNNEL = 124,
    FT_LIP_PUCKER_UPPER = 125,
    FT_LIP_PUCKER_LOWER = 126,
    FT_LIP_PUCKER = 127,
    FT_MOUTH_UPPER_UP = 128,
    FT_MOUTH_LOWER_DOWN = 129,
    FT_MOUTH_OPEN = 130,
    FT_MOUTH_RIGHT = 131,
    FT_MOUTH_LEFT = 132,
    FT_MOUTH_SMILE_RIGHT = 133,
    FT_MOUTH_SMILE_LEFT = 134,
    FT_MOUTH_SMILE = 135,
    FT_MOUTH_SAD_RIGHT = 136,
    FT_MOUTH_SAD_LEFT = 137,
    FT_MOUTH_SAD = 138,
    FT_MOUTH_STRETCH = 139,
    FT_MOUTH_DIMPLE = 140,
    FT_MOUTH_TIGHTENER = 141,
    FT_MOUTH_PRESS = 142,
    FT_MAX = 143,
}
## The array of face blend shape weights with indices corresponding to the [enum BlendShapeEntry] enum.
var blend_shapes: PackedFloat32Array:
	get = get_blend_shapes, set = set_blend_shapes

var type: int:
	get = get_tracker_type, set = set_tracker_type



## Returns the requested face blend shape weight.
func get_blend_shape(blend_shape: int) -> float:
	pass;

## Sets a face blend shape weight.
func set_blend_shape(blend_shape: int, weight: float) -> void:
	pass;


func get_blend_shapes() -> PackedFloat32Array:
	return blend_shapes

func set_blend_shapes(value: PackedFloat32Array) -> void:
	blend_shapes = value

func get_tracker_type() -> int:
	return type

func set_tracker_type(value: int) -> void:
	type = value

