extends Node3D
class_name XRFaceModifier3D

## A node for driving standard face meshes from [XRFaceTracker] weights.
##
## This node applies weights from a [XRFaceTracker] to a mesh with supporting face blend shapes.
## The [url=https://docs.vrcft.io/docs/tutorial-avatars/tutorial-avatars-extras/unified-blendshapes]Unified Expressions[/url] blend shapes are supported, as well as ARKit and SRanipal blend shapes.
## The node attempts to identify blend shapes based on name matching. Blend shapes should match the names listed in the [url=https://docs.vrcft.io/docs/tutorial-avatars/tutorial-avatars-extras/compatibility/overview]Unified Expressions Compatibility[/url] chart.
##
## @tutorial(XR documentation index): https://docs.godotengine.org/en/stable/tutorials/xr/index.html



## The [XRFaceTracker] path.
var face_tracker: StringName:
	get = get_face_tracker, set = set_face_tracker

## The [NodePath] of the face [MeshInstance3D].
var target: NodePath:
	get = get_target, set = set_target




func get_face_tracker() -> StringName:
	return face_tracker

func set_face_tracker(value: StringName) -> void:
	face_tracker = value

func get_target() -> NodePath:
	return target

func set_target(value: NodePath) -> void:
	target = value

