extends VisualShaderNode
class_name VisualShaderNodeRemap

## A visual shader node for remap function.
##
## Remap will transform the input range into output range, e.g. you can change a [code]0..1[/code] value to [code]-2..2[/code] etc. See [method @GlobalScope.remap] for more details.


## A floating-point scalar type.
## A 2D vector type.
## The [code]value[/code] port uses a 2D vector type, while the [code]input min[/code], [code]input max[/code], [code]output min[/code], and [code]output max[/code] ports use a floating-point scalar type.
## A 3D vector type.
## The [code]value[/code] port uses a 3D vector type, while the [code]input min[/code], [code]input max[/code], [code]output min[/code], and [code]output max[/code] ports use a floating-point scalar type.
## A 4D vector type.
## The [code]value[/code] port uses a 4D vector type, while the [code]input min[/code], [code]input max[/code], [code]output min[/code], and [code]output max[/code] ports use a floating-point scalar type.
## Represents the size of the [enum OpType] enum.

#enum OpType
enum {
    OP_TYPE_SCALAR = 0,
    OP_TYPE_VECTOR_2D = 1,
    OP_TYPE_VECTOR_2D_SCALAR = 2,
    OP_TYPE_VECTOR_3D = 3,
    OP_TYPE_VECTOR_3D_SCALAR = 4,
    OP_TYPE_VECTOR_4D = 5,
    OP_TYPE_VECTOR_4D_SCALAR = 6,
    OP_TYPE_MAX = 7,
}
var op_type: int:
	get = get_op_type, set = set_op_type




func get_op_type() -> int:
	return op_type

func set_op_type(value: int) -> void:
	op_type = value

