extends VisualShaderNodeResizableBase
class_name VisualShaderNodeFrame

## A frame other visual shader nodes can be attached to for better organization.
##
## A rectangular frame that can be used to group visual shader nodes together to improve organization.
## Nodes attached to the frame will move with it when it is dragged and it can automatically resize to enclose all attached nodes.
## Its title, description and color can be customized.



## The list of nodes attached to the frame.
var attached_nodes: PackedInt32Array:
	get = get_attached_nodes, set = set_attached_nodes

## If [code]true[/code], the frame will automatically resize to enclose all attached nodes.
var autoshrink: bool:
	get = is_autoshrink_enabled, set = set_autoshrink_enabled

## The color of the frame when [member tint_color_enabled] is [code]true[/code].
var tint_color: Color:
	get = get_tint_color, set = set_tint_color

## If [code]true[/code], the frame will be tinted with the color specified in [member tint_color].
var tint_color_enabled: bool:
	get = is_tint_color_enabled, set = set_tint_color_enabled

## The title of the node.
var title: String:
	get = get_title, set = set_title



## Adds a node to the list of nodes attached to the frame. Should not be called directly, use the [method VisualShader.attach_node_to_frame] method instead.
func add_attached_node(node: int) -> void:
	pass;

## Removes a node from the list of nodes attached to the frame. Should not be called directly, use the [method VisualShader.detach_node_from_frame] method instead.
func remove_attached_node(node: int) -> void:
	pass;


func get_attached_nodes() -> PackedInt32Array:
	return attached_nodes

func set_attached_nodes(value: PackedInt32Array) -> void:
	attached_nodes = value

func is_autoshrink_enabled() -> bool:
	return autoshrink

func set_autoshrink_enabled(value: bool) -> void:
	autoshrink = value

func get_tint_color() -> Color:
	return tint_color

func set_tint_color(value: Color) -> void:
	tint_color = value

func is_tint_color_enabled() -> bool:
	return tint_color_enabled

func set_tint_color_enabled(value: bool) -> void:
	tint_color_enabled = value

func get_title() -> String:
	return title

func set_title(value: String) -> void:
	title = value

