extends VisualShaderNodeConstant
class_name VisualShaderNodeBooleanConstant

## A boolean constant to be used within the visual shader graph.
##
## Has only one output port and no inputs.
## Translated to [code skip-lint]bool[/code] in the shader language.



## A boolean constant which represents a state of this node.
var constant: bool:
	get = get_constant, set = set_constant




func get_constant() -> bool:
	return constant

func set_constant(value: bool) -> void:
	constant = value

