extends Node2D
class_name VisibleOnScreenNotifier2D

## A rectangular region of 2D space that detects whether it is visible on screen.
##
## [VisibleOnScreenNotifier2D] represents a rectangular region of 2D space. When any part of this region becomes visible on screen or in a viewport, it will emit a [signal screen_entered] signal, and likewise it will emit a [signal screen_exited] signal when no part of it remains visible.
## If you want a node to be enabled automatically when this region is visible on screen, use [VisibleOnScreenEnabler2D].
## [b]Note:[/b] [VisibleOnScreenNotifier2D] uses the render culling code to determine whether it's visible on screen, so it won't function unless [member CanvasItem.visible] is set to [code]true[/code].
##
## @tutorial(2D Dodge The Creeps Demo): https://godotengine.org/asset-library/asset/2712


## Emitted when the VisibleOnScreenNotifier2D enters the screen.
signal screen_entered
## Emitted when the VisibleOnScreenNotifier2D exits the screen.
signal screen_exited

## The VisibleOnScreenNotifier2D's bounding rectangle.
var rect: Rect2:
	get = get_rect, set = set_rect



## If [code]true[/code], the bounding rectangle is on the screen.
## [b]Note:[/b] It takes one frame for the [VisibleOnScreenNotifier2D]'s visibility to be determined once added to the scene tree, so this method will always return [code]false[/code] right after it is instantiated, before the draw pass.
func is_on_screen() -> bool:
	pass;


func get_rect() -> Rect2:
	return rect

func set_rect(value: Rect2) -> void:
	rect = value

