extends Texture2D
class_name ViewportTexture

## Provides the content of a [Viewport] as a dynamic texture.
##
## A [ViewportTexture] provides the content of a [Viewport] as a dynamic [Texture2D]. This can be used to combine the rendering of [Control], [Node2D] and [Node3D] nodes. For example, you can use this texture to display a 3D scene inside a [TextureRect], or a 2D overlay in a [Sprite3D].
## To get a [ViewportTexture] in code, use the [method Viewport.get_texture] method on the target viewport.
## [b]Note:[/b] A [ViewportTexture] is always local to its scene (see [member Resource.resource_local_to_scene]). If the scene root is not ready, it may return incorrect data (see [signal Node.ready]).
## [b]Note:[/b] Instantiating scenes containing a high-resolution [ViewportTexture] may cause noticeable stutter.
## [b]Note:[/b] When using a [Viewport] with [member Viewport.use_hdr_2d] set to [code]true[/code], the returned texture will be an HDR image encoded in linear space. This may look darker than normal when displayed directly on screen. To convert to gamma space, you can do the following:
## [codeblock]
## img.convert(Image.FORMAT_RGBA8)
## imb.linear_to_srgb()
## [/codeblock]
## [b]Note:[/b] Some nodes such as [Decal], [Light3D], and [PointLight2D] do not support using [ViewportTexture] directly. To use texture data from a [ViewportTexture] in these nodes, you need to create an [ImageTexture] by calling [method Texture2D.get_image] on the [ViewportTexture] and passing the result to [method ImageTexture.create_from_image]. This conversion is a slow operation, so it should not be performed every frame.
##
## @tutorial(GUI in 3D Viewport Demo): https://godotengine.org/asset-library/asset/2807
## @tutorial(3D in 2D Viewport Demo): https://godotengine.org/asset-library/asset/2804
## @tutorial(2D in 3D Viewport Demo): https://godotengine.org/asset-library/asset/2803
## @tutorial(3D Resolution Scaling Demo): https://godotengine.org/asset-library/asset/2805



## The path to the [Viewport] node to display. This is relative to the local scene root (see [method Resource.get_local_scene]), [b]not[/b] to the nodes that use this texture.
## [b]Note:[/b] In the editor, this path is automatically updated when the target viewport or one of its ancestors is renamed or moved. At runtime, this path may not automatically update if the scene root cannot be found.
var viewport_path: NodePath:
	get = get_viewport_path_in_scene, set = set_viewport_path_in_scene




func get_viewport_path_in_scene() -> NodePath:
	return viewport_path

func set_viewport_path_in_scene(value: NodePath) -> void:
	viewport_path = value

