extends Node2D
class_name Sprite2D

## General-purpose sprite node.
##
## A node that displays a 2D texture. The texture displayed can be a region from a larger atlas texture, or a frame from a sprite sheet animation.
##
## @tutorial(Instancing Demo): https://godotengine.org/asset-library/asset/2716


## Emitted when the [member frame] changes.
signal frame_changed
## Emitted when the [member texture] changes.
signal texture_changed

## If [code]true[/code], texture is centered.
## [b]Note:[/b] For games with a pixel art aesthetic, textures may appear deformed when centered. This is caused by their position being between pixels. To prevent this, set this property to [code]false[/code], or consider enabling [member ProjectSettings.rendering/2d/snap/snap_2d_vertices_to_pixel] and [member ProjectSettings.rendering/2d/snap/snap_2d_transforms_to_pixel].
var centered: bool:
	get = is_centered, set = set_centered

## If [code]true[/code], texture is flipped horizontally.
var flip_h: bool:
	get = is_flipped_h, set = set_flip_h

## If [code]true[/code], texture is flipped vertically.
var flip_v: bool:
	get = is_flipped_v, set = set_flip_v

## Current frame to display from sprite sheet. [member hframes] or [member vframes] must be greater than 1. This property is automatically adjusted when [member hframes] or [member vframes] are changed to keep pointing to the same visual frame (same column and row). If that's impossible, this value is reset to [code]0[/code].
var frame: int:
	get = get_frame, set = set_frame

## Coordinates of the frame to display from sprite sheet. This is as an alias for the [member frame] property. [member hframes] or [member vframes] must be greater than 1.
var frame_coords: Vector2i:
	get = get_frame_coords, set = set_frame_coords

## The number of columns in the sprite sheet. When this property is changed, [member frame] is adjusted so that the same visual frame is maintained (same row and column). If that's impossible, [member frame] is reset to [code]0[/code].
var hframes: int:
	get = get_hframes, set = set_hframes

## The texture's drawing offset.
var offset: Vector2:
	get = get_offset, set = set_offset

## If [code]true[/code], texture is cut from a larger atlas texture. See [member region_rect].
var region_enabled: bool:
	get = is_region_enabled, set = set_region_enabled

## If [code]true[/code], the area outside of the [member region_rect] is clipped to avoid bleeding of the surrounding texture pixels. [member region_enabled] must be [code]true[/code].
var region_filter_clip_enabled: bool:
	get = is_region_filter_clip_enabled, set = set_region_filter_clip_enabled

## The region of the atlas texture to display. [member region_enabled] must be [code]true[/code].
var region_rect: Rect2:
	get = get_region_rect, set = set_region_rect

## [Texture2D] object to draw.
var texture: Texture2D:
	get = get_texture, set = set_texture

## The number of rows in the sprite sheet. When this property is changed, [member frame] is adjusted so that the same visual frame is maintained (same row and column). If that's impossible, [member frame] is reset to [code]0[/code].
var vframes: int:
	get = get_vframes, set = set_vframes



## Returns a [Rect2] representing the Sprite2D's boundary in local coordinates.
## [b]Example:[/b] Detect if the Sprite2D was clicked:
## [codeblocks]
## [gdscript]
## func _input(event):
## if event is InputEventMouseButton and event.pressed and event.button_index == MOUSE_BUTTON_LEFT:
## if get_rect().has_point(to_local(event.position)):
## print("A click!")
## [/gdscript]
## [csharp]
## public override void _Input(InputEvent @event)
## {
## if (@event is InputEventMouseButton inputEventMouse)
## {
## if (inputEventMouse.Pressed && inputEventMouse.ButtonIndex == MouseButton.Left)
## {
## if (GetRect().HasPoint(ToLocal(inputEventMouse.Position)))
## {
## GD.Print("A click!");
## }
## }
## }
## }
## [/csharp]
## [/codeblocks]
func get_rect() -> Rect2:
	pass;

## Returns [code]true[/code], if the pixel at the given position is opaque and [code]false[/code] in other case. The position is in local coordinates.
## [b]Note:[/b] It also returns [code]false[/code], if the sprite's texture is [code]null[/code] or if the given position is invalid.
func is_pixel_opaque(pos: Vector2) -> bool:
	pass;


func is_centered() -> bool:
	return centered

func set_centered(value: bool) -> void:
	centered = value

func is_flipped_h() -> bool:
	return flip_h

func set_flip_h(value: bool) -> void:
	flip_h = value

func is_flipped_v() -> bool:
	return flip_v

func set_flip_v(value: bool) -> void:
	flip_v = value

func get_frame() -> int:
	return frame

func set_frame(value: int) -> void:
	frame = value

func get_frame_coords() -> Vector2i:
	return frame_coords

func set_frame_coords(value: Vector2i) -> void:
	frame_coords = value

func get_hframes() -> int:
	return hframes

func set_hframes(value: int) -> void:
	hframes = value

func get_offset() -> Vector2:
	return offset

func set_offset(value: Vector2) -> void:
	offset = value

func is_region_enabled() -> bool:
	return region_enabled

func set_region_enabled(value: bool) -> void:
	region_enabled = value

func is_region_filter_clip_enabled() -> bool:
	return region_filter_clip_enabled

func set_region_filter_clip_enabled(value: bool) -> void:
	region_filter_clip_enabled = value

func get_region_rect() -> Rect2:
	return region_rect

func set_region_rect(value: Rect2) -> void:
	region_rect = value

func get_texture() -> Texture2D:
	return texture

func set_texture(value: Texture2D) -> void:
	texture = value

func get_vframes() -> int:
	return vframes

func set_vframes(value: int) -> void:
	vframes = value

