extends Node3D
class_name SkeletonModifier3D

## A node that may modify Skeleton3D's bone.
##
## [SkeletonModifier3D] retrieves a target [Skeleton3D] by having a [Skeleton3D] parent.
## If there is [AnimationMixer], modification always performs after playback process of the [AnimationMixer].
## This node should be used to implement custom IK solvers, constraints, or skeleton physics.
##
## @tutorial(Design of the Skeleton Modifier 3D): https://godotengine.org/article/design-of-the-skeleton-modifier-3d/


## Notifies when the modification have been finished.
## [b]Note:[/b] If you want to get the modified bone pose by the modifier, you must use [method Skeleton3D.get_bone_pose] or [method Skeleton3D.get_bone_global_pose] at the moment this signal is fired.
signal modification_processed
## Enumerated value for the +X axis.
## Enumerated value for the -X axis.
## Enumerated value for the +Y axis.
## Enumerated value for the -Y axis.
## Enumerated value for the +Z axis.
## Enumerated value for the -Z axis.

#enum BoneAxis
enum {
    BONE_AXIS_PLUS_X = 0,
    BONE_AXIS_MINUS_X = 1,
    BONE_AXIS_PLUS_Y = 2,
    BONE_AXIS_MINUS_Y = 3,
    BONE_AXIS_PLUS_Z = 4,
    BONE_AXIS_MINUS_Z = 5,
}
## If [code]true[/code], the [SkeletonModifier3D] will be processing.
var active: bool:
	get = is_active, set = set_active

## Sets the influence of the modification.
## [b]Note:[/b] This value is used by [Skeleton3D] to blend, so the [SkeletonModifier3D] should always apply only 100% of the result without interpolation.
var influence: float:
	get = get_influence, set = set_influence



## Override this virtual method to implement a custom skeleton modifier. You should do things like get the [Skeleton3D]'s current pose and apply the pose here.
## [method _process_modification] must not apply [member influence] to bone poses because the [Skeleton3D] automatically applies influence to all bone poses set by the modifier.
func _process_modification() -> void:
	pass;

## Get parent [Skeleton3D] node if found.
func get_skeleton() -> Skeleton3D:
	pass;


func is_active() -> bool:
	return active

func set_active(value: bool) -> void:
	active = value

func get_influence() -> float:
	return influence

func set_influence(value: float) -> void:
	influence = value

