extends Resource
class_name ShaderInclude

## A snippet of shader code to be included in a [Shader] with [code]#include[/code].
##
## A shader include file, saved with the [code].gdshaderinc[/code] extension. This class allows you to define a custom shader snippet that can be included in a [Shader] by using the preprocessor directive [code]#include[/code], followed by the file path (e.g. [code]#include "res://shader_lib.gdshaderinc"[/code]). The snippet doesn't have to be a valid shader on its own.
##
## @tutorial(Shader preprocessor): https://docs.godotengine.org/en/stable/tutorials/shaders/shader_reference/shader_preprocessor.html



## Returns the code of the shader include file. The returned text is what the user has written, not the full generated code used internally.
var code: String:
	get = get_code, set = set_code




func get_code() -> String:
	return code

func set_code(value: String) -> void:
	code = value

