extends Resource
class_name SceneReplicationConfig

## Configuration for properties to synchronize with a [MultiplayerSynchronizer].


## Do not keep the given property synchronized.
## Replicate the given property on process by constantly sending updates using unreliable transfer mode.
## Replicate the given property on process by sending updates using reliable transfer mode when its value changes.

#enum ReplicationMode
enum {
    REPLICATION_MODE_NEVER = 0,
    REPLICATION_MODE_ALWAYS = 1,
    REPLICATION_MODE_ON_CHANGE = 2,
}


## Adds the property identified by the given [param path] to the list of the properties being synchronized, optionally passing an [param index].
## [b]Note:[/b] For details on restrictions and limitations on property synchronization, see [MultiplayerSynchronizer].
func add_property(path: NodePath, index: int = -1) -> void:
	pass;

## Returns a list of synchronized property [NodePath]s.
func get_properties() -> Array[NodePath]:
	pass;

## Returns [code]true[/code] if the given [param path] is configured for synchronization.
func has_property(path: NodePath) -> bool:
	pass;

## Finds the index of the given [param path].
func property_get_index(path: NodePath) -> int:
	pass;

## Returns the replication mode for the property identified by the given [param path]. See [enum ReplicationMode].
func property_get_replication_mode(path: NodePath) -> int:
	pass;

## Returns [code]true[/code] if the property identified by the given [param path] is configured to be synchronized on spawn.
func property_get_spawn(path: NodePath) -> bool:
	pass;

## Returns [code]true[/code] if the property identified by the given [param path] is configured to be synchronized on process.
func property_get_sync(path: NodePath) -> bool:
	pass;

## Returns [code]true[/code] if the property identified by the given [param path] is configured to be reliably synchronized when changes are detected on process.
func property_get_watch(path: NodePath) -> bool:
	pass;

## Sets the synchronization mode for the property identified by the given [param path]. See [enum ReplicationMode].
func property_set_replication_mode(path: NodePath, mode: int) -> void:
	pass;

## Sets whether the property identified by the given [param path] is configured to be synchronized on spawn.
func property_set_spawn(path: NodePath, enabled: bool) -> void:
	pass;

## Sets whether the property identified by the given [param path] is configured to be synchronized on process.
func property_set_sync(path: NodePath, enabled: bool) -> void:
	pass;

## Sets whether the property identified by the given [param path] is configured to be reliably synchronized when changes are detected on process.
func property_set_watch(path: NodePath, enabled: bool) -> void:
	pass;

## Removes the property identified by the given [param path] from the configuration.
func remove_property(path: NodePath) -> void:
	pass;


