extends SkeletonModifier3D
class_name RetargetModifier3D

## A modifier to transfer parent skeleton poses (or global poses) to child skeletons in model space with different rests.
##
## Retrieves the pose (or global pose) relative to the parent Skeleton's rest in model space and transfers it to the child Skeleton.
## This modifier rewrites the pose of the child skeleton directly in the parent skeleton's update process. This means that it overwrites the mapped bone pose set in the normal process on the target skeleton. If you want to set the target skeleton bone pose after retargeting, you will need to add a [SkeletonModifier3D] child to the target skeleton and thereby modify the pose.
## [b]Note:[/b] When the [member use_global_pose] is enabled, even if it is an unmapped bone, it can cause visual problems because the global pose is applied ignoring the parent bone's pose [b]if it has mapped bone children[/b]. See also [member use_global_pose].


## If set, allows to retarget the position.
## If set, allows to retarget the rotation.
## If set, allows to retarget the scale.
## If set, allows to retarget the position/rotation/scale.

#enum TransformFlag
enum {
    TRANSFORM_FLAG_POSITION = 1,
    TRANSFORM_FLAG_ROTATION = 2,
    TRANSFORM_FLAG_SCALE = 4,
    TRANSFORM_FLAG_ALL = 7,
}
## Flags to control the process of the transform elements individually when [member use_global_pose] is disabled.
var enable: int:
	get = get_enable_flags, set = set_enable_flags

## [SkeletonProfile] for retargeting bones with names matching the bone list.
var profile: SkeletonProfile:
	get = get_profile, set = set_profile

## If [code]false[/code], in case the target skeleton has fewer bones than the source skeleton, the source bone parent's transform will be ignored.
## Instead, it is possible to retarget between models with different body shapes, and position, rotation, and scale can be retargeted separately.
## If [code]true[/code], retargeting is performed taking into account global pose.
## In case the target skeleton has fewer bones than the source skeleton, the source bone parent's transform is taken into account. However, bone length between skeletons must match exactly, if not, the bones will be forced to expand or shrink.
## This is useful for using dummy bone with length [code]0[/code] to match postures when retargeting between models with different number of bones.
var use_global_pose: bool:
	get = is_using_global_pose, set = set_use_global_pose



## Returns [code]true[/code] if [member enable] has [constant TRANSFORM_FLAG_POSITION].
func is_position_enabled() -> bool:
	pass;

## Returns [code]true[/code] if [member enable] has [constant TRANSFORM_FLAG_ROTATION].
func is_rotation_enabled() -> bool:
	pass;

## Returns [code]true[/code] if [member enable] has [constant TRANSFORM_FLAG_SCALE].
func is_scale_enabled() -> bool:
	pass;

## Sets [constant TRANSFORM_FLAG_POSITION] into [member enable].
func set_position_enabled(enabled: bool) -> void:
	pass;

## Sets [constant TRANSFORM_FLAG_ROTATION] into [member enable].
func set_rotation_enabled(enabled: bool) -> void:
	pass;

## Sets [constant TRANSFORM_FLAG_SCALE] into [member enable].
func set_scale_enabled(enabled: bool) -> void:
	pass;


func get_enable_flags() -> int:
	return enable

func set_enable_flags(value: int) -> void:
	enable = value

func get_profile() -> SkeletonProfile:
	return profile

func set_profile(value: SkeletonProfile) -> void:
	profile = value

func is_using_global_pose() -> bool:
	return use_global_pose

func set_use_global_pose(value: bool) -> void:
	use_global_pose = value

