extends Object
class_name ResourceUID

## A singleton that manages the unique identifiers of all resources within a project.
##
## Resource UIDs (Unique IDentifiers) allow the engine to keep references between resources intact, even if files are renamed or moved. They can be accessed with [code]uid://[/code].
## [ResourceUID] keeps track of all registered resource UIDs in a project, generates new UIDs, and converts between their string and integer representations.


## The value to use for an invalid UID, for example if the resource could not be loaded.
## Its text representation is [code]uid://<invalid>[/code].
const INVALID_ID = -1;




## Adds a new UID value which is mapped to the given resource path.
## Fails with an error if the UID already exists, so be sure to check [method has_id] beforehand, or use [method set_id] instead.
func add_id(id: int, path: String) -> void:
	pass;

## Generates a random resource UID which is guaranteed to be unique within the list of currently loaded UIDs.
## In order for this UID to be registered, you must call [method add_id] or [method set_id].
func create_id() -> int:
	pass;

## Returns the path that the given UID value refers to.
## Fails with an error if the UID does not exist, so be sure to check [method has_id] beforehand.
func get_id_path(id: int) -> String:
	pass;

## Returns whether the given UID value is known to the cache.
func has_id(id: int) -> bool:
	pass;

## Converts the given UID to a [code]uid://[/code] string value.
func id_to_text(id: int) -> String:
	pass;

## Removes a loaded UID value from the cache.
## Fails with an error if the UID does not exist, so be sure to check [method has_id] beforehand.
func remove_id(id: int) -> void:
	pass;

## Updates the resource path of an existing UID.
## Fails with an error if the UID does not exist, so be sure to check [method has_id] beforehand, or use [method add_id] instead.
func set_id(id: int, path: String) -> void:
	pass;

## Extracts the UID value from the given [code]uid://[/code] string.
func text_to_id(text_id: String) -> int:
	pass;


