extends ResourceImporter
class_name ResourceImporterCSVTranslation

## Imports comma-separated values
##
## Comma-separated values are a plain text table storage format. The format's simplicity makes it easy to edit in any text editor or spreadsheet software. This makes it a common choice for game localization.
## [b]Example CSV file:[/b]
## [codeblock lang=text]
## keys,en,es,ja
## GREET,"Hello, friend!","Hola, amigo!",こんにちは
## ASK,How are you?,Cómo está?,元気ですか
## BYE,Goodbye,Adiós,さようなら
## QUOTE,"""Hello"" said the man.","""Hola"" dijo el hombre.",「こんにちは」男は言いました
## [/codeblock]
##
## @tutorial(Importing translations): https://docs.godotengine.org/en/stable/tutorials/assets_pipeline/importing_translations.html



## If [code]true[/code], creates an [OptimizedTranslation] instead of a [Translation]. This makes the resulting file smaller at the cost of a small CPU overhead.
var compress: bool

## The delimiter to use in the CSV file. The default value matches the common CSV convention. Tab-separated values are sometimes called TSV files.
var delimiter: int




