extends RefCounted
class_name RenderSceneBuffersConfiguration

## Configuration object used to setup a [RenderSceneBuffers] object.
##
## This configuration object is created and populated by the render engine on a viewport change and used to (re)configure a [RenderSceneBuffers] object.



## Level of the anisotropic filter.
var anisotropic_filtering_level: int:
	get = get_anisotropic_filtering_level, set = set_anisotropic_filtering_level

## FSR Sharpness applicable if FSR upscaling is used.
var fsr_sharpness: float:
	get = get_fsr_sharpness, set = set_fsr_sharpness

## The size of the 3D render buffer used for rendering.
var internal_size: Vector2i:
	get = get_internal_size, set = set_internal_size

## The MSAA mode we're using for 3D rendering.
var msaa_3d: int:
	get = get_msaa_3d, set = set_msaa_3d

## The render target associated with these buffer.
var render_target: RID:
	get = get_render_target, set = set_render_target

## The requested scaling mode with which we upscale/downscale if [member internal_size] and [member target_size] are not equal.
var scaling_3d_mode: int:
	get = get_scaling_3d_mode, set = set_scaling_3d_mode

## The requested screen space AA applied in post processing.
var screen_space_aa: int:
	get = get_screen_space_aa, set = set_screen_space_aa

## The target (upscale) size if scaling is used.
var target_size: Vector2i:
	get = get_target_size, set = set_target_size

## Bias applied to mipmaps.
var texture_mipmap_bias: float:
	get = get_texture_mipmap_bias, set = set_texture_mipmap_bias

## The number of views we're rendering.
var view_count: int:
	get = get_view_count, set = set_view_count




func get_anisotropic_filtering_level() -> int:
	return anisotropic_filtering_level

func set_anisotropic_filtering_level(value: int) -> void:
	anisotropic_filtering_level = value

func get_fsr_sharpness() -> float:
	return fsr_sharpness

func set_fsr_sharpness(value: float) -> void:
	fsr_sharpness = value

func get_internal_size() -> Vector2i:
	return internal_size

func set_internal_size(value: Vector2i) -> void:
	internal_size = value

func get_msaa_3d() -> int:
	return msaa_3d

func set_msaa_3d(value: int) -> void:
	msaa_3d = value

func get_render_target() -> RID:
	return render_target

func set_render_target(value: RID) -> void:
	render_target = value

func get_scaling_3d_mode() -> int:
	return scaling_3d_mode

func set_scaling_3d_mode(value: int) -> void:
	scaling_3d_mode = value

func get_screen_space_aa() -> int:
	return screen_space_aa

func set_screen_space_aa(value: int) -> void:
	screen_space_aa = value

func get_target_size() -> Vector2i:
	return target_size

func set_target_size(value: Vector2i) -> void:
	target_size = value

func get_texture_mipmap_bias() -> float:
	return texture_mipmap_bias

func set_texture_mipmap_bias(value: float) -> void:
	texture_mipmap_bias = value

func get_view_count() -> int:
	return view_count

func set_view_count(value: int) -> void:
	view_count = value

