class_name Rect2i

## A 2D axis-aligned bounding box using integer coordinates.
##
## The [Rect2i] built-in [Variant] type represents an axis-aligned rectangle in a 2D space, using integer coordinates. It is defined by its [member position] and [member size], which are [Vector2i]. Because it does not rotate, it is frequently used for fast overlap tests (see [method intersects]).
## For floating-point coordinates, see [Rect2].
## [b]Note:[/b] Negative values for [member size] are not supported. With negative size, most [Rect2i] methods do not work correctly. Use [method abs] to get an equivalent [Rect2i] with a non-negative size.
## [b]Note:[/b] In a boolean context, a [Rect2i] evaluates to [code]false[/code] if both [member position] and [member size] are zero (equal to [constant Vector2i.ZERO]). Otherwise, it always evaluates to [code]true[/code].
##
## @tutorial(Math documentation index): https://docs.godotengine.org/en/stable/tutorials/math/index.html
## @tutorial(Vector math): https://docs.godotengine.org/en/stable/tutorials/math/vector_math.html



## The ending point. This is usually the bottom-right corner of the rectangle, and is equivalent to [code]position + size[/code]. Setting this point affects the [member size].
var end: Vector2i

## The origin point. This is usually the top-left corner of the rectangle.
var position: Vector2i

## The rectangle's width and height, starting from [member position]. Setting this value also affects the [member end] point.
## [b]Note:[/b] It's recommended setting the width and height to non-negative values, as most methods in Godot assume that the [member position] is the top-left corner, and the [member end] is the bottom-right corner. To get an equivalent rectangle with non-negative size, use [method abs].
var size: Vector2i


## Constructs a [Rect2i] with its [member position] and [member size] set to [constant Vector2i.ZERO].
func Rect2i() -> Rect2i:
	pass;

## Constructs a [Rect2i] as a copy of the given [Rect2i].
func Rect2i(from: Rect2i) -> Rect2i:
	pass;

## Constructs a [Rect2i] from a [Rect2]. The floating-point coordinates are truncated.
func Rect2i(from: Rect2) -> Rect2i:
	pass;

## Constructs a [Rect2i] by [param position] and [param size].
func Rect2i(position: Vector2i, size: Vector2i) -> Rect2i:
	pass;

## Constructs a [Rect2i] by setting its [member position] to ([param x], [param y]), and its [member size] to ([param width], [param height]).
func Rect2i(x: int, y: int, width: int, height: int) -> Rect2i:
	pass;


## Returns a [Rect2i] equivalent to this rectangle, with its width and height modified to be non-negative values, and with its [member position] being the top-left corner of the rectangle.
## [codeblocks]
## [gdscript]
## var rect = Rect2i(25, 25, -100, -50)
## var absolute = rect.abs() # absolute is Rect2i(-75, -25, 100, 50)
## [/gdscript]
## [csharp]
## var rect = new Rect2I(25, 25, -100, -50);
## var absolute = rect.Abs(); // absolute is Rect2I(-75, -25, 100, 50)
## [/csharp]
## [/codeblocks]
## [b]Note:[/b] It's recommended to use this method when [member size] is negative, as most other methods in Godot assume that the [member position] is the top-left corner, and the [member end] is the bottom-right corner.
func abs() -> Rect2i:
	pass;

## Returns [code]true[/code] if this [Rect2i] completely encloses another one.
func encloses(b: Rect2i) -> bool:
	pass;

## Returns a copy of this rectangle expanded to align the edges with the given [param to] point, if necessary.
## [codeblocks]
## [gdscript]
## var rect = Rect2i(0, 0, 5, 2)
## rect = rect.expand(Vector2i(10, 0)) # rect is Rect2i(0, 0, 10, 2)
## rect = rect.expand(Vector2i(-5, 5)) # rect is Rect2i(-5, 0, 15, 5)
## [/gdscript]
## [csharp]
## var rect = new Rect2I(0, 0, 5, 2);
## rect = rect.Expand(new Vector2I(10, 0)); // rect is Rect2I(0, 0, 10, 2)
## rect = rect.Expand(new Vector2I(-5, 5)); // rect is Rect2I(-5, 0, 15, 5)
## [/csharp]
## [/codeblocks]
func expand(to: Vector2i) -> Rect2i:
	pass;

## Returns the rectangle's area. This is equivalent to [code]size.x * size.y[/code]. See also [method has_area].
func get_area() -> int:
	pass;

## Returns the center point of the rectangle. This is the same as [code]position + (size / 2)[/code].
## [b]Note:[/b] If the [member size] is odd, the result will be rounded towards [member position].
func get_center() -> Vector2i:
	pass;

## Returns a copy of this rectangle extended on all sides by the given [param amount]. A negative [param amount] shrinks the rectangle instead. See also [method grow_individual] and [method grow_side].
## [codeblocks]
## [gdscript]
## var a = Rect2i(4, 4, 8, 8).grow(4) # a is Rect2i(0, 0, 16, 16)
## var b = Rect2i(0, 0, 8, 4).grow(2) # b is Rect2i(-2, -2, 12, 8)
## [/gdscript]
## [csharp]
## var a = new Rect2I(4, 4, 8, 8).Grow(4); // a is Rect2I(0, 0, 16, 16)
## var b = new Rect2I(0, 0, 8, 4).Grow(2); // b is Rect2I(-2, -2, 12, 8)
## [/csharp]
## [/codeblocks]
func grow(amount: int) -> Rect2i:
	pass;

## Returns a copy of this rectangle with its [param left], [param top], [param right], and [param bottom] sides extended by the given amounts. Negative values shrink the sides, instead. See also [method grow] and [method grow_side].
func grow_individual(left: int, top: int, right: int, bottom: int) -> Rect2i:
	pass;

## Returns a copy of this rectangle with its [param side] extended by the given [param amount] (see [enum Side] constants). A negative [param amount] shrinks the rectangle, instead. See also [method grow] and [method grow_individual].
func grow_side(side: int, amount: int) -> Rect2i:
	pass;

## Returns [code]true[/code] if this rectangle has positive width and height. See also [method get_area].
func has_area() -> bool:
	pass;

## Returns [code]true[/code] if the rectangle contains the given [param point]. By convention, points on the right and bottom edges are [b]not[/b] included.
## [b]Note:[/b] This method is not reliable for [Rect2i] with a [i]negative[/i] [member size]. Use [method abs] first to get a valid rectangle.
func has_point(point: Vector2i) -> bool:
	pass;

## Returns the intersection between this rectangle and [param b]. If the rectangles do not intersect, returns an empty [Rect2i].
## [codeblocks]
## [gdscript]
## var a = Rect2i(0, 0, 5, 10)
## var b = Rect2i(2, 0, 8, 4)
## var c = a.intersection(b) # c is Rect2i(2, 0, 3, 4)
## [/gdscript]
## [csharp]
## var a = new Rect2I(0, 0, 5, 10);
## var b = new Rect2I(2, 0, 8, 4);
## var c = rect1.Intersection(rect2); // c is Rect2I(2, 0, 3, 4)
## [/csharp]
## [/codeblocks]
## [b]Note:[/b] If you only need to know whether two rectangles are overlapping, use [method intersects], instead.
func intersection(b: Rect2i) -> Rect2i:
	pass;

## Returns [code]true[/code] if this rectangle overlaps with the [param b] rectangle. The edges of both rectangles are excluded.
func intersects(b: Rect2i) -> bool:
	pass;

## Returns a [Rect2i] that encloses both this rectangle and [param b] around the edges. See also [method encloses].
func merge(b: Rect2i) -> Rect2i:
	pass;


