extends Resource
class_name PolygonPathFinder






func find_path(from: Vector2, to: Vector2) -> PackedVector2Array:
	pass;

func get_bounds() -> Rect2:
	pass;

func get_closest_point(point: Vector2) -> Vector2:
	pass;

func get_intersections(from: Vector2, to: Vector2) -> PackedVector2Array:
	pass;

func get_point_penalty(idx: int) -> float:
	pass;

## Returns [code]true[/code] if [param point] falls inside the polygon area.
## [codeblocks]
## [gdscript]
## var polygon_path_finder = PolygonPathFinder.new()
## var points = [Vector2(0.0, 0.0), Vector2(1.0, 0.0), Vector2(0.0, 1.0)]
## var connections = [0, 1, 1, 2, 2, 0]
## polygon_path_finder.setup(points, connections)
## print(polygon_path_finder.is_point_inside(Vector2(0.2, 0.2))) # Prints true
## print(polygon_path_finder.is_point_inside(Vector2(1.0, 1.0))) # Prints false
## [/gdscript]
## [csharp]
## var polygonPathFinder = new PolygonPathFinder();
## Vector2[] points =
## [
## new Vector2(0.0f, 0.0f),
## new Vector2(1.0f, 0.0f),
## new Vector2(0.0f, 1.0f)
## ];
## int[] connections = [0, 1, 1, 2, 2, 0];
## polygonPathFinder.Setup(points, connections);
## GD.Print(polygonPathFinder.IsPointInside(new Vector2(0.2f, 0.2f))); // Prints True
## GD.Print(polygonPathFinder.IsPointInside(new Vector2(1.0f, 1.0f))); // Prints False
## [/csharp]
## [/codeblocks]
func is_point_inside(point: Vector2) -> bool:
	pass;

func set_point_penalty(idx: int, penalty: float) -> void:
	pass;

## Sets up [PolygonPathFinder] with an array of points that define the vertices of the polygon, and an array of indices that determine the edges of the polygon.
## The length of [param connections] must be even, returns an error if odd.
## [codeblocks]
## [gdscript]
## var polygon_path_finder = PolygonPathFinder.new()
## var points = [Vector2(0.0, 0.0), Vector2(1.0, 0.0), Vector2(0.0, 1.0)]
## var connections = [0, 1, 1, 2, 2, 0]
## polygon_path_finder.setup(points, connections)
## [/gdscript]
## [csharp]
## var polygonPathFinder = new PolygonPathFinder();
## Vector2[] points =
## [
## new Vector2(0.0f, 0.0f),
## new Vector2(1.0f, 0.0f),
## new Vector2(0.0f, 1.0f)
## ];
## int[] connections = [0, 1, 1, 2, 2, 0];
## polygonPathFinder.Setup(points, connections);
## [/csharp]
## [/codeblocks]
func setup(points: PackedVector2Array, connections: PackedInt32Array) -> void:
	pass;


