extends Joint3D
class_name PinJoint3D

## A physics joint that attaches two 3D physics bodies at a single point, allowing them to freely rotate.
##
## A physics joint that attaches two 3D physics bodies at a single point, allowing them to freely rotate. For example, a [RigidBody3D] can be attached to a [StaticBody3D] to create a pendulum or a seesaw.


## The force with which the pinned objects stay in positional relation to each other. The higher, the stronger.
## The force with which the pinned objects stay in velocity relation to each other. The higher, the stronger.
## If above 0, this value is the maximum value for an impulse that this Joint3D produces.

#enum Param
enum {
    PARAM_BIAS = 0,
    PARAM_DAMPING = 1,
    PARAM_IMPULSE_CLAMP = 2,
}
## The force with which the pinned objects stay in positional relation to each other. The higher, the stronger.
var params/bias: float:
	get = get_param, set = set_param

## The force with which the pinned objects stay in velocity relation to each other. The higher, the stronger.
var params/damping: float:
	get = get_param, set = set_param

## If above 0, this value is the maximum value for an impulse that this Joint3D produces.
var params/impulse_clamp: float:
	get = get_param, set = set_param



## Returns the value of the specified parameter.
func get_param(param: int) -> float:
	pass;

## Sets the value of the specified parameter.
func set_param(param: int, value: float) -> void:
	pass;


func get_param() -> float:
	return params/bias

func set_param(value: float) -> void:
	params/bias = value

func get_param() -> float:
	return params/damping

func set_param(value: float) -> void:
	params/damping = value

func get_param() -> float:
	return params/impulse_clamp

func set_param(value: float) -> void:
	params/impulse_clamp = value

