extends Joint2D
class_name PinJoint2D

## A physics joint that attaches two 2D physics bodies at a single point, allowing them to freely rotate.
##
## A physics joint that attaches two 2D physics bodies at a single point, allowing them to freely rotate. For example, a [RigidBody2D] can be attached to a [StaticBody2D] to create a pendulum or a seesaw.



## If [code]true[/code], the pin maximum and minimum rotation, defined by [member angular_limit_lower] and [member angular_limit_upper] are applied.
var angular_limit_enabled: bool:
	get = is_angular_limit_enabled, set = set_angular_limit_enabled

## The minimum rotation. Only active if [member angular_limit_enabled] is [code]true[/code].
var angular_limit_lower: float:
	get = get_angular_limit_lower, set = set_angular_limit_lower

## The maximum rotation. Only active if [member angular_limit_enabled] is [code]true[/code].
var angular_limit_upper: float:
	get = get_angular_limit_upper, set = set_angular_limit_upper

## When activated, a motor turns the pin.
var motor_enabled: bool:
	get = is_motor_enabled, set = set_motor_enabled

## Target speed for the motor. In radians per second.
var motor_target_velocity: float:
	get = get_motor_target_velocity, set = set_motor_target_velocity

## The higher this value, the more the bond to the pinned partner can flex.
var softness: float:
	get = get_softness, set = set_softness




func is_angular_limit_enabled() -> bool:
	return angular_limit_enabled

func set_angular_limit_enabled(value: bool) -> void:
	angular_limit_enabled = value

func get_angular_limit_lower() -> float:
	return angular_limit_lower

func set_angular_limit_lower(value: float) -> void:
	angular_limit_lower = value

func get_angular_limit_upper() -> float:
	return angular_limit_upper

func set_angular_limit_upper(value: float) -> void:
	angular_limit_upper = value

func is_motor_enabled() -> bool:
	return motor_enabled

func set_motor_enabled(value: bool) -> void:
	motor_enabled = value

func get_motor_target_velocity() -> float:
	return motor_target_velocity

func set_motor_target_velocity(value: float) -> void:
	motor_target_velocity = value

func get_softness() -> float:
	return softness

func set_softness(value: float) -> void:
	softness = value

