extends Material
class_name PanoramaSkyMaterial

## A material that provides a special texture to a [Sky], usually an HDR panorama.
##
## A resource referenced in a [Sky] that is used to draw a background. [PanoramaSkyMaterial] functions similar to skyboxes in other engines, except it uses an equirectangular sky map instead of a [Cubemap].
## Using an HDR panorama is strongly recommended for accurate, high-quality reflections. Godot supports the Radiance HDR ([code].hdr[/code]) and OpenEXR ([code].exr[/code]) image formats for this purpose.
## You can use [url=https://danilw.github.io/GLSL-howto/cubemap_to_panorama_js/cubemap_to_panorama.html]this tool[/url] to convert a cubemap to an equirectangular sky map.



## The sky's overall brightness multiplier. Higher values result in a brighter sky.
var energy_multiplier: float:
	get = get_energy_multiplier, set = set_energy_multiplier

## A boolean value to determine if the background texture should be filtered or not.
var filter: bool:
	get = is_filtering_enabled, set = set_filtering_enabled

## [Texture2D] to be applied to the [PanoramaSkyMaterial].
var panorama: Texture2D:
	get = get_panorama, set = set_panorama




func get_energy_multiplier() -> float:
	return energy_multiplier

func set_energy_multiplier(value: float) -> void:
	energy_multiplier = value

func is_filtering_enabled() -> bool:
	return filter

func set_filtering_enabled(value: bool) -> void:
	filter = value

func get_panorama() -> Texture2D:
	return panorama

func set_panorama(value: Texture2D) -> void:
	panorama = value

