extends RefCounted
class_name PCKPacker

## Creates packages that can be loaded into a running project.
##
## The [PCKPacker] is used to create packages that can be loaded into a running project using [method ProjectSettings.load_resource_pack].
## [codeblocks]
## [gdscript]
## var packer = PCKPacker.new()
## packer.pck_start("test.pck")
## packer.add_file("res://text.txt", "text.txt")
## packer.flush()
## [/gdscript]
## [csharp]
## var packer = new PckPacker();
## packer.PckStart("test.pck");
## packer.AddFile("res://text.txt", "text.txt");
## packer.Flush();
## [/csharp]
## [/codeblocks]
## The above [PCKPacker] creates package [code]test.pck[/code], then adds a file named [code]text.txt[/code] at the root of the package.
## [b]Note:[/b] PCK is Godot's own pack file format. To create ZIP archives that can be read by any program, use [ZIPPacker] instead.





## Adds the [param source_path] file to the current PCK package at the [param target_path] internal path. The [code]res://[/code] prefix for [param target_path] is optional and stripped internally.
func add_file(target_path: String, source_path: String, encrypt: bool = false) -> int:
	pass;

## Registers a file removal of the [param target_path] internal path to the PCK. This is mainly used for patches. If the file at this path has been loaded from a previous PCK, it will be removed. The [code]res://[/code] prefix for [param target_path] is optional and stripped internally.
func add_file_removal(target_path: String) -> int:
	pass;

## Writes the files specified using all [method add_file] calls since the last flush. If [param verbose] is [code]true[/code], a list of files added will be printed to the console for easier debugging.
func flush(verbose: bool = false) -> int:
	pass;

## Creates a new PCK file at the file path [param pck_path]. The [code].pck[/code] file extension isn't added automatically, so it should be part of [param pck_path] (even though it's not required).
func pck_start(pck_path: String, alignment: int = 32, key: String = "0000000000000000000000000000000000000000000000000000000000000000", encrypt_directory: bool = false) -> int:
	pass;


