extends HBoxContainer
class_name OpenXRInteractionProfileEditorBase

## Base class for editing interaction profiles.
##
## This is a base class for interaction profile editors used by the OpenXR action map editor. It can be used to create bespoke editors for specific interaction profiles.



var size_flags_horizontal: int:
	get = get_h_size_flags, set = set_h_size_flags

var size_flags_vertical: int:
	get = get_v_size_flags, set = set_v_size_flags



## Setup this editor for the provided [param action_map] and [param interaction_profile].
func setup(action_map: OpenXRActionMap, interaction_profile: OpenXRInteractionProfile) -> void:
	pass;


func get_h_size_flags() -> int:
	return size_flags_horizontal

func set_h_size_flags(value: int) -> void:
	size_flags_horizontal = value

func get_v_size_flags() -> int:
	return size_flags_vertical

func set_v_size_flags(value: int) -> void:
	size_flags_vertical = value

