extends Resource
class_name OpenXRInteractionProfile

## Suggested bindings object for OpenXR.
##
## This object stores suggested bindings for an interaction profile. Interaction profiles define the metadata for a tracked XR device such as an XR controller.
## For more information see the [url=https://www.khronos.org/registry/OpenXR/specs/1.0/html/xrspec.html#semantic-path-interaction-profiles]interaction profiles info in the OpenXR specification[/url].



## Binding modifiers for this interaction profile.
var binding_modifiers: Array:
	get = get_binding_modifiers, set = set_binding_modifiers

## Action bindings for this interaction profile.
var bindings: Array:
	get = get_bindings, set = set_bindings

## The interaction profile path identifying the XR device.
var interaction_profile_path: String:
	get = get_interaction_profile_path, set = set_interaction_profile_path



## Retrieve the binding at this index.
func get_binding(index: int) -> OpenXRIPBinding:
	pass;

## Get the number of bindings in this interaction profile.
func get_binding_count() -> int:
	pass;

## Get the [OpenXRBindingModifier] at this index.
func get_binding_modifier(index: int) -> OpenXRIPBindingModifier:
	pass;

## Get the number of binding modifiers in this interaction profile.
func get_binding_modifier_count() -> int:
	pass;


func get_binding_modifiers() -> Array:
	return binding_modifiers

func set_binding_modifiers(value: Array) -> void:
	binding_modifiers = value

func get_bindings() -> Array:
	return bindings

func set_bindings(value: Array) -> void:
	bindings = value

func get_interaction_profile_path() -> String:
	return interaction_profile_path

func set_interaction_profile_path(value: String) -> void:
	interaction_profile_path = value

