extends OpenXRIPBindingModifier
class_name OpenXRDpadBindingModifier

## The DPad binding modifier converts an axis input to a dpad output.
##
## The DPad binding modifier converts an axis input to a dpad output, emulating a DPad. New input paths for each dpad direction will be added to the interaction profile. When bound to actions the DPad emulation will be activated. You should [b]not[/b] combine dpad inputs with normal inputs in the same action set for the same control, this will result in an error being returned when suggested bindings are submitted to OpenXR.
## See [url=https://registry.khronos.org/OpenXR/specs/1.1/html/xrspec.html#XR_EXT_dpad_binding]XR_EXT_dpad_binding[/url] for in-depth details.
## [b]Note:[/b] If the DPad binding modifier extension is enabled, all dpad binding paths will be available in the action map. Adding the modifier to an interaction profile allows you to further customize the behavior.



## Action set for which this dpad binding modifier is active.
var action_set: OpenXRActionSet:
	get = get_action_set, set = set_action_set

## Center region in which our center position of our dpad return [code]true[/code].
var center_region: float:
	get = get_center_region, set = set_center_region

## Input path for this dpad binding modifier.
var input_path: String:
	get = get_input_path, set = set_input_path

## If [code]false[/code], when the joystick enters a new dpad zone this becomes true.
## If [code]true[/code], when the joystick remains in active dpad zone, this remains true even if we overlap with another zone.
var is_sticky: bool:
	get = get_is_sticky, set = set_is_sticky

## Haptic pulse to emit when the user releases the input.
var off_haptic: OpenXRHapticBase:
	get = get_off_haptic, set = set_off_haptic

## Haptic pulse to emit when the user presses the input.
var on_haptic: OpenXRHapticBase:
	get = get_on_haptic, set = set_on_haptic

## When our input value is equal or larger than this value, our dpad in that direction becomes true. It stays true until it falls under the [member threshold_released] value.
var threshold: float:
	get = get_threshold, set = set_threshold

## When our input value falls below this, our output becomes false.
var threshold_released: float:
	get = get_threshold_released, set = set_threshold_released

## The angle of each wedge that identifies the 4 directions of the emulated dpad.
var wedge_angle: float:
	get = get_wedge_angle, set = set_wedge_angle




func get_action_set() -> OpenXRActionSet:
	return action_set

func set_action_set(value: OpenXRActionSet) -> void:
	action_set = value

func get_center_region() -> float:
	return center_region

func set_center_region(value: float) -> void:
	center_region = value

func get_input_path() -> String:
	return input_path

func set_input_path(value: String) -> void:
	input_path = value

func get_is_sticky() -> bool:
	return is_sticky

func set_is_sticky(value: bool) -> void:
	is_sticky = value

func get_off_haptic() -> OpenXRHapticBase:
	return off_haptic

func set_off_haptic(value: OpenXRHapticBase) -> void:
	off_haptic = value

func get_on_haptic() -> OpenXRHapticBase:
	return on_haptic

func set_on_haptic(value: OpenXRHapticBase) -> void:
	on_haptic = value

func get_threshold() -> float:
	return threshold

func set_threshold(value: float) -> void:
	threshold = value

func get_threshold_released() -> float:
	return threshold_released

func set_threshold_released(value: float) -> void:
	threshold_released = value

func get_wedge_angle() -> float:
	return wedge_angle

func set_wedge_angle(value: float) -> void:
	wedge_angle = value

