extends OpenXRActionBindingModifier
class_name OpenXRAnalogThresholdModifier

## The analog threshold binding modifier can modify a float input to a boolean input with specified thresholds.
##
## The analog threshold binding modifier can modify a float input to a boolean input with specified thresholds.
## See [url=https://registry.khronos.org/OpenXR/specs/1.1/html/xrspec.html#XR_VALVE_analog_threshold]XR_VALVE_analog_threshold[/url] for in-depth details.



## Haptic pulse to emit when the user releases the input.
var off_haptic: OpenXRHapticBase:
	get = get_off_haptic, set = set_off_haptic

## When our input value falls below this, our output becomes false.
var off_threshold: float:
	get = get_off_threshold, set = set_off_threshold

## Haptic pulse to emit when the user presses the input.
var on_haptic: OpenXRHapticBase:
	get = get_on_haptic, set = set_on_haptic

## When our input value is equal or larger than this value, our output becomes true. It stays true until it falls under the [member off_threshold] value.
var on_threshold: float:
	get = get_on_threshold, set = set_on_threshold




func get_off_haptic() -> OpenXRHapticBase:
	return off_haptic

func set_off_haptic(value: OpenXRHapticBase) -> void:
	off_haptic = value

func get_off_threshold() -> float:
	return off_threshold

func set_off_threshold(value: float) -> void:
	off_threshold = value

func get_on_haptic() -> OpenXRHapticBase:
	return on_haptic

func set_on_haptic(value: OpenXRHapticBase) -> void:
	on_haptic = value

func get_on_threshold() -> float:
	return on_threshold

func set_on_threshold(value: float) -> void:
	on_threshold = value

