extends Node2D
class_name NavigationObstacle2D

## 2D obstacle used to affect navigation mesh baking or constrain velocities of avoidance controlled agents.
##
## An obstacle needs a navigation map and outline [member vertices] defined to work correctly. The outlines can not cross or overlap.
## Obstacles can be included in the navigation mesh baking process when [member affect_navigation_mesh] is enabled. They do not add walkable geometry, instead their role is to discard other source geometry inside the shape. This can be used to prevent navigation mesh from appearing in unwanted places. If [member carve_navigation_mesh] is enabled the baked shape will not be affected by offsets of the navigation mesh baking, e.g. the agent radius.
## With [member avoidance_enabled] the obstacle can constrain the avoidance velocities of avoidance using agents. If the obstacle's vertices are wound in clockwise order, avoidance agents will be pushed in by the obstacle, otherwise, avoidance agents will be pushed out. Obstacles using vertices and avoidance can warp to a new position but should not be moved every single frame as each change requires a rebuild of the avoidance map.
##
## @tutorial(Using NavigationObstacles): https://docs.godotengine.org/en/stable/tutorials/navigation/navigation_using_navigationobstacles.html



## If enabled and parsed in a navigation mesh baking process the obstacle will discard source geometry inside its [member vertices] defined shape.
var affect_navigation_mesh: bool:
	get = get_affect_navigation_mesh, set = set_affect_navigation_mesh

## If [code]true[/code] the obstacle affects avoidance using agents.
var avoidance_enabled: bool:
	get = get_avoidance_enabled, set = set_avoidance_enabled

## A bitfield determining the avoidance layers for this obstacle. Agents with a matching bit on the their avoidance mask will avoid this obstacle.
var avoidance_layers: int:
	get = get_avoidance_layers, set = set_avoidance_layers

## If enabled the obstacle vertices will carve into the baked navigation mesh with the shape unaffected by additional offsets (e.g. agent radius).
## It will still be affected by further postprocessing of the baking process, like edge and polygon simplification.
## Requires [member affect_navigation_mesh] to be enabled.
var carve_navigation_mesh: bool:
	get = get_carve_navigation_mesh, set = set_carve_navigation_mesh

## Sets the avoidance radius for the obstacle.
var radius: float:
	get = get_radius, set = set_radius

## Sets the wanted velocity for the obstacle so other agent's can better predict the obstacle if it is moved with a velocity regularly (every frame) instead of warped to a new position. Does only affect avoidance for the obstacles [member radius]. Does nothing for the obstacles static vertices.
var velocity: Vector2:
	get = get_velocity, set = set_velocity

## The outline vertices of the obstacle. If the vertices are winded in clockwise order agents will be pushed in by the obstacle, else they will be pushed out. Outlines can not be crossed or overlap. Should the vertices using obstacle be warped to a new position agent's can not predict this movement and may get trapped inside the obstacle.
var vertices: PackedVector2Array:
	get = get_vertices, set = set_vertices



## Returns whether or not the specified layer of the [member avoidance_layers] bitmask is enabled, given a [param layer_number] between 1 and 32.
func get_avoidance_layer_value(layer_number: int) -> bool:
	pass;

## Returns the [RID] of the navigation map for this NavigationObstacle node. This function returns always the map set on the NavigationObstacle node and not the map of the abstract obstacle on the NavigationServer. If the obstacle map is changed directly with the NavigationServer API the NavigationObstacle node will not be aware of the map change. Use [method set_navigation_map] to change the navigation map for the NavigationObstacle and also update the obstacle on the NavigationServer.
func get_navigation_map() -> RID:
	pass;

## Returns the [RID] of this obstacle on the [NavigationServer2D].
func get_rid() -> RID:
	pass;

## Based on [param value], enables or disables the specified layer in the [member avoidance_layers] bitmask, given a [param layer_number] between 1 and 32.
func set_avoidance_layer_value(layer_number: int, value: bool) -> void:
	pass;

## Sets the [RID] of the navigation map this NavigationObstacle node should use and also updates the [code]obstacle[/code] on the NavigationServer.
func set_navigation_map(navigation_map: RID) -> void:
	pass;


func get_affect_navigation_mesh() -> bool:
	return affect_navigation_mesh

func set_affect_navigation_mesh(value: bool) -> void:
	affect_navigation_mesh = value

func get_avoidance_enabled() -> bool:
	return avoidance_enabled

func set_avoidance_enabled(value: bool) -> void:
	avoidance_enabled = value

func get_avoidance_layers() -> int:
	return avoidance_layers

func set_avoidance_layers(value: int) -> void:
	avoidance_layers = value

func get_carve_navigation_mesh() -> bool:
	return carve_navigation_mesh

func set_carve_navigation_mesh(value: bool) -> void:
	carve_navigation_mesh = value

func get_radius() -> float:
	return radius

func set_radius(value: float) -> void:
	radius = value

func get_velocity() -> Vector2:
	return velocity

func set_velocity(value: Vector2) -> void:
	velocity = value

func get_vertices() -> PackedVector2Array:
	return vertices

func set_vertices(value: PackedVector2Array) -> void:
	vertices = value

