extends Object
class_name NativeMenu

## A server interface for OS native menus.
##
## [NativeMenu] handles low-level access to the OS native global menu bar and popup menus.
## [b]Note:[/b] This is low-level API, consider using [MenuBar] with [member MenuBar.prefer_global_menu] set to [code]true[/code], and [PopupMenu] with [member PopupMenu.prefer_native_menu] set to [code]true[/code].
## To create a menu, use [method create_menu], add menu items using [code]add_*_item[/code] methods. To remove a menu, use [method free_menu].
## [codeblock]
## var menu
## func _menu_callback(item_id):
## if item_id == "ITEM_CUT":
## cut()
## elif item_id == "ITEM_COPY":
## copy()
## elif item_id == "ITEM_PASTE":
## paste()
## func _enter_tree():
## # Create new menu and add items:
## menu = NativeMenu.create_menu()
## NativeMenu.add_item(menu, "Cut", _menu_callback, Callable(), "ITEM_CUT")
## NativeMenu.add_item(menu, "Copy", _menu_callback, Callable(), "ITEM_COPY")
## NativeMenu.add_separator(menu)
## NativeMenu.add_item(menu, "Paste", _menu_callback, Callable(), "ITEM_PASTE")
## func _on_button_pressed():
## # Show popup menu at mouse position:
## NativeMenu.popup(menu, DisplayServer.mouse_get_position())
## func _exit_tree():
## # Remove menu when it's no longer needed:
## NativeMenu.free_menu(menu)
## [/codeblock]


## [NativeMenu] supports native global main menu.
## [NativeMenu] supports native popup menus.
## [NativeMenu] supports menu open and close callbacks.
## [NativeMenu] supports menu item hover callback.
## [NativeMenu] supports menu item accelerator/key callback.
## Invalid special system menu ID.
## Global main menu ID.
## Application (first menu after "Apple" menu on macOS) menu ID.
## "Window" menu ID (on macOS this menu includes standard window control items and a list of open windows).
## "Help" menu ID (on macOS this menu includes help search bar).
## Dock icon right-click menu ID (on macOS this menu include standard application control items and a list of open windows).

#enum Feature
enum {
    FEATURE_GLOBAL_MENU = 0,
    FEATURE_POPUP_MENU = 1,
    FEATURE_OPEN_CLOSE_CALLBACK = 2,
    FEATURE_HOVER_CALLBACK = 3,
    FEATURE_KEY_CALLBACK = 4,
}
#enum SystemMenus
enum {
    INVALID_MENU_ID = 0,
    MAIN_MENU_ID = 1,
    APPLICATION_MENU_ID = 2,
    WINDOW_MENU_ID = 3,
    HELP_MENU_ID = 4,
    DOCK_MENU_ID = 5,
}


## Adds a new checkable item with text [param label] to the global menu [param rid].
## Returns index of the inserted item, it's not guaranteed to be the same as [param index] value.
## An [param accelerator] can optionally be defined, which is a keyboard shortcut that can be pressed to trigger the menu button even if it's not currently open. The [param accelerator] is generally a combination of [enum KeyModifierMask]s and [enum Key]s using bitwise OR such as [code]KEY_MASK_CTRL | KEY_A[/code] ([kbd]Ctrl + A[/kbd]).
## [b]Note:[/b] The [param callback] and [param key_callback] Callables need to accept exactly one Variant parameter, the parameter passed to the Callables will be the value passed to [param tag].
## [b]Note:[/b] This method is implemented on macOS and Windows.
## [b]Note:[/b] On Windows, [param accelerator] and [param key_callback] are ignored.
func add_check_item(rid: RID, label: String, callback: Callable = Callable(), key_callback: Callable = Callable(), tag: Variant = null, accelerator: int = 0, index: int = -1) -> int:
	pass;

## Adds a new checkable item with text [param label] and icon [param icon] to the global menu [param rid].
## Returns index of the inserted item, it's not guaranteed to be the same as [param index] value.
## An [param accelerator] can optionally be defined, which is a keyboard shortcut that can be pressed to trigger the menu button even if it's not currently open. The [param accelerator] is generally a combination of [enum KeyModifierMask]s and [enum Key]s using bitwise OR such as [code]KEY_MASK_CTRL | KEY_A[/code] ([kbd]Ctrl + A[/kbd]).
## [b]Note:[/b] The [param callback] and [param key_callback] Callables need to accept exactly one Variant parameter, the parameter passed to the Callables will be the value passed to [param tag].
## [b]Note:[/b] This method is implemented on macOS and Windows.
## [b]Note:[/b] On Windows, [param accelerator] and [param key_callback] are ignored.
func add_icon_check_item(rid: RID, icon: Texture2D, label: String, callback: Callable = Callable(), key_callback: Callable = Callable(), tag: Variant = null, accelerator: int = 0, index: int = -1) -> int:
	pass;

## Adds a new item with text [param label] and icon [param icon] to the global menu [param rid].
## Returns index of the inserted item, it's not guaranteed to be the same as [param index] value.
## An [param accelerator] can optionally be defined, which is a keyboard shortcut that can be pressed to trigger the menu button even if it's not currently open. The [param accelerator] is generally a combination of [enum KeyModifierMask]s and [enum Key]s using bitwise OR such as [code]KEY_MASK_CTRL | KEY_A[/code] ([kbd]Ctrl + A[/kbd]).
## [b]Note:[/b] The [param callback] and [param key_callback] Callables need to accept exactly one Variant parameter, the parameter passed to the Callables will be the value passed to [param tag].
## [b]Note:[/b] This method is implemented on macOS and Windows.
## [b]Note:[/b] On Windows, [param accelerator] and [param key_callback] are ignored.
func add_icon_item(rid: RID, icon: Texture2D, label: String, callback: Callable = Callable(), key_callback: Callable = Callable(), tag: Variant = null, accelerator: int = 0, index: int = -1) -> int:
	pass;

## Adds a new radio-checkable item with text [param label] and icon [param icon] to the global menu [param rid].
## Returns index of the inserted item, it's not guaranteed to be the same as [param index] value.
## An [param accelerator] can optionally be defined, which is a keyboard shortcut that can be pressed to trigger the menu button even if it's not currently open. The [param accelerator] is generally a combination of [enum KeyModifierMask]s and [enum Key]s using bitwise OR such as [code]KEY_MASK_CTRL | KEY_A[/code] ([kbd]Ctrl + A[/kbd]).
## [b]Note:[/b] Radio-checkable items just display a checkmark, but don't have any built-in checking behavior and must be checked/unchecked manually. See [method set_item_checked] for more info on how to control it.
## [b]Note:[/b] The [param callback] and [param key_callback] Callables need to accept exactly one Variant parameter, the parameter passed to the Callables will be the value passed to [param tag].
## [b]Note:[/b] This method is implemented on macOS and Windows.
## [b]Note:[/b] On Windows, [param accelerator] and [param key_callback] are ignored.
func add_icon_radio_check_item(rid: RID, icon: Texture2D, label: String, callback: Callable = Callable(), key_callback: Callable = Callable(), tag: Variant = null, accelerator: int = 0, index: int = -1) -> int:
	pass;

## Adds a new item with text [param label] to the global menu [param rid].
## Returns index of the inserted item, it's not guaranteed to be the same as [param index] value.
## An [param accelerator] can optionally be defined, which is a keyboard shortcut that can be pressed to trigger the menu button even if it's not currently open. The [param accelerator] is generally a combination of [enum KeyModifierMask]s and [enum Key]s using bitwise OR such as [code]KEY_MASK_CTRL | KEY_A[/code] ([kbd]Ctrl + A[/kbd]).
## [b]Note:[/b] The [param callback] and [param key_callback] Callables need to accept exactly one Variant parameter, the parameter passed to the Callables will be the value passed to [param tag].
## [b]Note:[/b] This method is implemented on macOS and Windows.
## [b]Note:[/b] On Windows, [param accelerator] and [param key_callback] are ignored.
func add_item(rid: RID, label: String, callback: Callable = Callable(), key_callback: Callable = Callable(), tag: Variant = null, accelerator: int = 0, index: int = -1) -> int:
	pass;

## Adds a new item with text [param label] to the global menu [param rid].
## Contrarily to normal binary items, multistate items can have more than two states, as defined by [param max_states]. Each press or activate of the item will increase the state by one. The default value is defined by [param default_state].
## Returns index of the inserted item, it's not guaranteed to be the same as [param index] value.
## An [param accelerator] can optionally be defined, which is a keyboard shortcut that can be pressed to trigger the menu button even if it's not currently open. The [param accelerator] is generally a combination of [enum KeyModifierMask]s and [enum Key]s using bitwise OR such as [code]KEY_MASK_CTRL | KEY_A[/code] ([kbd]Ctrl + A[/kbd]).
## [b]Note:[/b] By default, there's no indication of the current item state, it should be changed manually.
## [b]Note:[/b] The [param callback] and [param key_callback] Callables need to accept exactly one Variant parameter, the parameter passed to the Callables will be the value passed to [param tag].
## [b]Note:[/b] This method is implemented on macOS and Windows.
## [b]Note:[/b] On Windows, [param accelerator] and [param key_callback] are ignored.
func add_multistate_item(rid: RID, label: String, max_states: int, default_state: int, callback: Callable = Callable(), key_callback: Callable = Callable(), tag: Variant = null, accelerator: int = 0, index: int = -1) -> int:
	pass;

## Adds a new radio-checkable item with text [param label] to the global menu [param rid].
## Returns index of the inserted item, it's not guaranteed to be the same as [param index] value.
## An [param accelerator] can optionally be defined, which is a keyboard shortcut that can be pressed to trigger the menu button even if it's not currently open. The [param accelerator] is generally a combination of [enum KeyModifierMask]s and [enum Key]s using bitwise OR such as [code]KEY_MASK_CTRL | KEY_A[/code] ([kbd]Ctrl + A[/kbd]).
## [b]Note:[/b] Radio-checkable items just display a checkmark, but don't have any built-in checking behavior and must be checked/unchecked manually. See [method set_item_checked] for more info on how to control it.
## [b]Note:[/b] The [param callback] and [param key_callback] Callables need to accept exactly one Variant parameter, the parameter passed to the Callables will be the value passed to [param tag].
## [b]Note:[/b] This method is implemented on macOS and Windows.
## [b]Note:[/b] On Windows, [param accelerator] and [param key_callback] are ignored.
func add_radio_check_item(rid: RID, label: String, callback: Callable = Callable(), key_callback: Callable = Callable(), tag: Variant = null, accelerator: int = 0, index: int = -1) -> int:
	pass;

## Adds a separator between items to the global menu [param rid]. Separators also occupy an index.
## Returns index of the inserted item, it's not guaranteed to be the same as [param index] value.
## [b]Note:[/b] This method is implemented on macOS and Windows.
func add_separator(rid: RID, index: int = -1) -> int:
	pass;

## Adds an item that will act as a submenu of the global menu [param rid]. The [param submenu_rid] argument is the RID of the global menu that will be shown when the item is clicked.
## Returns index of the inserted item, it's not guaranteed to be the same as [param index] value.
## [b]Note:[/b] This method is implemented on macOS and Windows.
func add_submenu_item(rid: RID, label: String, submenu_rid: RID, tag: Variant = null, index: int = -1) -> int:
	pass;

## Removes all items from the global menu [param rid].
## [b]Note:[/b] This method is implemented on macOS and Windows.
func clear(rid: RID) -> void:
	pass;

## Creates a new global menu object.
## [b]Note:[/b] This method is implemented on macOS and Windows.
func create_menu() -> RID:
	pass;

## Returns the index of the item with the submenu specified by [param submenu_rid]. Indices are automatically assigned to each item by the engine, and cannot be set manually.
## [b]Note:[/b] This method is implemented on macOS and Windows.
func find_item_index_with_submenu(rid: RID, submenu_rid: RID) -> int:
	pass;

## Returns the index of the item with the specified [param tag]. Indices are automatically assigned to each item by the engine, and cannot be set manually.
## [b]Note:[/b] This method is implemented on macOS and Windows.
func find_item_index_with_tag(rid: RID, tag: Variant) -> int:
	pass;

## Returns the index of the item with the specified [param text]. Indices are automatically assigned to each item by the engine, and cannot be set manually.
## [b]Note:[/b] This method is implemented on macOS and Windows.
func find_item_index_with_text(rid: RID, text: String) -> int:
	pass;

## Frees a global menu object created by this [NativeMenu].
## [b]Note:[/b] This method is implemented on macOS and Windows.
func free_menu(rid: RID) -> void:
	pass;

## Returns the accelerator of the item at index [param idx]. Accelerators are special combinations of keys that activate the item, no matter which control is focused.
## [b]Note:[/b] This method is implemented only on macOS.
func get_item_accelerator(rid: RID, idx: int) -> int:
	pass;

## Returns the callback of the item at index [param idx].
## [b]Note:[/b] This method is implemented on macOS and Windows.
func get_item_callback(rid: RID, idx: int) -> Callable:
	pass;

## Returns number of items in the global menu [param rid].
## [b]Note:[/b] This method is implemented on macOS and Windows.
func get_item_count(rid: RID) -> int:
	pass;

## Returns the icon of the item at index [param idx].
## [b]Note:[/b] This method is implemented on macOS and Windows.
func get_item_icon(rid: RID, idx: int) -> Texture2D:
	pass;

## Returns the horizontal offset of the item at the given [param idx].
## [b]Note:[/b] This method is implemented only on macOS.
func get_item_indentation_level(rid: RID, idx: int) -> int:
	pass;

## Returns the callback of the item accelerator at index [param idx].
## [b]Note:[/b] This method is implemented only on macOS.
func get_item_key_callback(rid: RID, idx: int) -> Callable:
	pass;

## Returns number of states of a multistate item. See [method add_multistate_item] for details.
## [b]Note:[/b] This method is implemented on macOS and Windows.
func get_item_max_states(rid: RID, idx: int) -> int:
	pass;

## Returns the state of a multistate item. See [method add_multistate_item] for details.
## [b]Note:[/b] This method is implemented on macOS and Windows.
func get_item_state(rid: RID, idx: int) -> int:
	pass;

## Returns the submenu ID of the item at index [param idx]. See [method add_submenu_item] for more info on how to add a submenu.
## [b]Note:[/b] This method is implemented on macOS and Windows.
func get_item_submenu(rid: RID, idx: int) -> RID:
	pass;

## Returns the metadata of the specified item, which might be of any type. You can set it with [method set_item_tag], which provides a simple way of assigning context data to items.
## [b]Note:[/b] This method is implemented on macOS and Windows.
func get_item_tag(rid: RID, idx: int) -> Variant:
	pass;

## Returns the text of the item at index [param idx].
## [b]Note:[/b] This method is implemented on macOS and Windows.
func get_item_text(rid: RID, idx: int) -> String:
	pass;

## Returns the tooltip associated with the specified index [param idx].
## [b]Note:[/b] This method is implemented only on macOS.
func get_item_tooltip(rid: RID, idx: int) -> String:
	pass;

## Returns global menu minimum width.
## [b]Note:[/b] This method is implemented only on macOS.
func get_minimum_width(rid: RID) -> float:
	pass;

## Returns global menu close callback.
## [b]Note:[/b] This method is implemented on macOS and Windows.
func get_popup_close_callback(rid: RID) -> Callable:
	pass;

## Returns global menu open callback.
## b]Note:[/b] This method is implemented only on macOS.
func get_popup_open_callback(rid: RID) -> Callable:
	pass;

## Returns global menu size.
## [b]Note:[/b] This method is implemented on macOS and Windows.
func get_size(rid: RID) -> Vector2:
	pass;

## Returns RID of a special system menu.
## [b]Note:[/b] This method is implemented only on macOS.
func get_system_menu(menu_id: int) -> RID:
	pass;

## Returns readable name of a special system menu.
## [b]Note:[/b] This method is implemented only on macOS.
func get_system_menu_name(menu_id: int) -> String:
	pass;

## Returns [code]true[/code] if the specified [param feature] is supported by the current [NativeMenu], [code]false[/code] otherwise.
## [b]Note:[/b] This method is implemented on macOS and Windows.
func has_feature(feature: int) -> bool:
	pass;

## Returns [code]true[/code] if [param rid] is valid global menu.
## [b]Note:[/b] This method is implemented on macOS and Windows.
func has_menu(rid: RID) -> bool:
	pass;

## Returns [code]true[/code] if a special system menu is supported.
## [b]Note:[/b] This method is implemented only on macOS.
func has_system_menu(menu_id: int) -> bool:
	pass;

## Returns [code]true[/code] if the item at index [param idx] is checkable in some way, i.e. if it has a checkbox or radio button.
## [b]Note:[/b] This method is implemented on macOS and Windows.
func is_item_checkable(rid: RID, idx: int) -> bool:
	pass;

## Returns [code]true[/code] if the item at index [param idx] is checked.
## [b]Note:[/b] This method is implemented on macOS and Windows.
func is_item_checked(rid: RID, idx: int) -> bool:
	pass;

## Returns [code]true[/code] if the item at index [param idx] is disabled. When it is disabled it can't be selected, or its action invoked.
## See [method set_item_disabled] for more info on how to disable an item.
## [b]Note:[/b] This method is implemented on macOS and Windows.
func is_item_disabled(rid: RID, idx: int) -> bool:
	pass;

## Returns [code]true[/code] if the item at index [param idx] is hidden.
## See [method set_item_hidden] for more info on how to hide an item.
## [b]Note:[/b] This method is implemented only on macOS.
func is_item_hidden(rid: RID, idx: int) -> bool:
	pass;

## Returns [code]true[/code] if the item at index [param idx] has radio button-style checkability.
## [b]Note:[/b] This is purely cosmetic; you must add the logic for checking/unchecking items in radio groups.
## [b]Note:[/b] This method is implemented on macOS and Windows.
func is_item_radio_checkable(rid: RID, idx: int) -> bool:
	pass;

## Returns [code]true[/code] if the menu is currently opened.
## [b]Note:[/b] This method is implemented only on macOS.
func is_opened(rid: RID) -> bool:
	pass;

## Return [code]true[/code] is global menu is a special system menu.
## [b]Note:[/b] This method is implemented only on macOS.
func is_system_menu(rid: RID) -> bool:
	pass;

## Shows the global menu at [param position] in the screen coordinates.
## [b]Note:[/b] This method is implemented on macOS and Windows.
func popup(rid: RID, position: Vector2i) -> void:
	pass;

## Removes the item at index [param idx] from the global menu [param rid].
## [b]Note:[/b] The indices of items after the removed item will be shifted by one.
## [b]Note:[/b] This method is implemented on macOS and Windows.
func remove_item(rid: RID, idx: int) -> void:
	pass;

## Sets the menu text layout direction from right-to-left if [param is_rtl] is [code]true[/code].
## [b]Note:[/b] This method is implemented on macOS and Windows.
func set_interface_direction(rid: RID, is_rtl: bool) -> void:
	pass;

## Sets the accelerator of the item at index [param idx]. [param keycode] can be a single [enum Key], or a combination of [enum KeyModifierMask]s and [enum Key]s using bitwise OR such as [code]KEY_MASK_CTRL | KEY_A[/code] ([kbd]Ctrl + A[/kbd]).
## [b]Note:[/b] This method is implemented only on macOS.
func set_item_accelerator(rid: RID, idx: int, keycode: int) -> void:
	pass;

## Sets the callback of the item at index [param idx]. Callback is emitted when an item is pressed.
## [b]Note:[/b] The [param callback] Callable needs to accept exactly one Variant parameter, the parameter passed to the Callable will be the value passed to the [code]tag[/code] parameter when the menu item was created.
## [b]Note:[/b] This method is implemented on macOS and Windows.
func set_item_callback(rid: RID, idx: int, callback: Callable) -> void:
	pass;

## Sets whether the item at index [param idx] has a checkbox. If [code]false[/code], sets the type of the item to plain text.
## [b]Note:[/b] This method is implemented on macOS and Windows.
func set_item_checkable(rid: RID, idx: int, checkable: bool) -> void:
	pass;

## Sets the checkstate status of the item at index [param idx].
## [b]Note:[/b] This method is implemented on macOS and Windows.
func set_item_checked(rid: RID, idx: int, checked: bool) -> void:
	pass;

## Enables/disables the item at index [param idx]. When it is disabled, it can't be selected and its action can't be invoked.
## [b]Note:[/b] This method is implemented on macOS and Windows.
func set_item_disabled(rid: RID, idx: int, disabled: bool) -> void:
	pass;

## Hides/shows the item at index [param idx]. When it is hidden, an item does not appear in a menu and its action cannot be invoked.
## [b]Note:[/b] This method is implemented only on macOS.
func set_item_hidden(rid: RID, idx: int, hidden: bool) -> void:
	pass;

## Sets the callback of the item at index [param idx]. The callback is emitted when an item is hovered.
## [b]Note:[/b] The [param callback] Callable needs to accept exactly one Variant parameter, the parameter passed to the Callable will be the value passed to the [code]tag[/code] parameter when the menu item was created.
## [b]Note:[/b] This method is implemented only on macOS.
func set_item_hover_callbacks(rid: RID, idx: int, callback: Callable) -> void:
	pass;

## Replaces the [Texture2D] icon of the specified [param idx].
## [b]Note:[/b] This method is implemented on macOS and Windows.
## [b]Note:[/b] This method is not supported by macOS Dock menu items.
func set_item_icon(rid: RID, idx: int, icon: Texture2D) -> void:
	pass;

## Sets the horizontal offset of the item at the given [param idx].
## [b]Note:[/b] This method is implemented only on macOS.
func set_item_indentation_level(rid: RID, idx: int, level: int) -> void:
	pass;

## Sets the callback of the item at index [param idx]. Callback is emitted when its accelerator is activated.
## [b]Note:[/b] The [param key_callback] Callable needs to accept exactly one Variant parameter, the parameter passed to the Callable will be the value passed to the [code]tag[/code] parameter when the menu item was created.
## [b]Note:[/b] This method is implemented only on macOS.
func set_item_key_callback(rid: RID, idx: int, key_callback: Callable) -> void:
	pass;

## Sets number of state of a multistate item. See [method add_multistate_item] for details.
## [b]Note:[/b] This method is implemented on macOS and Windows.
func set_item_max_states(rid: RID, idx: int, max_states: int) -> void:
	pass;

## Sets the type of the item at the specified index [param idx] to radio button. If [code]false[/code], sets the type of the item to plain text.
## [b]Note:[/b] This is purely cosmetic; you must add the logic for checking/unchecking items in radio groups.
## [b]Note:[/b] This method is implemented on macOS and Windows.
func set_item_radio_checkable(rid: RID, idx: int, checkable: bool) -> void:
	pass;

## Sets the state of a multistate item. See [method add_multistate_item] for details.
## [b]Note:[/b] This method is implemented on macOS and Windows.
func set_item_state(rid: RID, idx: int, state: int) -> void:
	pass;

## Sets the submenu RID of the item at index [param idx]. The submenu is a global menu that would be shown when the item is clicked.
## [b]Note:[/b] This method is implemented on macOS and Windows.
func set_item_submenu(rid: RID, idx: int, submenu_rid: RID) -> void:
	pass;

## Sets the metadata of an item, which may be of any type. You can later get it with [method get_item_tag], which provides a simple way of assigning context data to items.
## [b]Note:[/b] This method is implemented on macOS and Windows.
func set_item_tag(rid: RID, idx: int, tag: Variant) -> void:
	pass;

## Sets the text of the item at index [param idx].
## [b]Note:[/b] This method is implemented on macOS and Windows.
func set_item_text(rid: RID, idx: int, text: String) -> void:
	pass;

## Sets the [String] tooltip of the item at the specified index [param idx].
## [b]Note:[/b] This method is implemented only on macOS.
func set_item_tooltip(rid: RID, idx: int, tooltip: String) -> void:
	pass;

## Sets the minimum width of the global menu.
## [b]Note:[/b] This method is implemented only on macOS.
func set_minimum_width(rid: RID, width: float) -> void:
	pass;

## Registers callable to emit when the menu is about to show.
## [b]Note:[/b] The OS can simulate menu opening to track menu item changes and global shortcuts, in which case the corresponding close callback is not triggered. Use [method is_opened] to check if the menu is currently opened.
## [b]Note:[/b] This method is implemented on macOS and Windows.
func set_popup_close_callback(rid: RID, callback: Callable) -> void:
	pass;

## Registers callable to emit after the menu is closed.
## [b]Note:[/b] This method is implemented only on macOS.
func set_popup_open_callback(rid: RID, callback: Callable) -> void:
	pass;


