extends Resource
class_name MissingResource

## An internal editor class intended for keeping the data of unrecognized resources.
##
## This is an internal editor class intended for keeping data of resources of unknown type (most likely this type was supplied by an extension that is no longer loaded). It can't be manually instantiated or placed in a scene.
## [b]Warning:[/b] Ignore missing resources unless you know what you are doing. Existing properties on a missing resource can be freely modified in code, regardless of the type they are intended to be.



## The name of the class this resource was supposed to be (see [method Object.get_class]).
var original_class: String:
	get = get_original_class, set = set_original_class

## If set to [code]true[/code], allows new properties to be added on top of the existing ones with [method Object.set].
var recording_properties: bool:
	get = is_recording_properties, set = set_recording_properties




func get_original_class() -> String:
	return original_class

func set_original_class(value: String) -> void:
	original_class = value

func is_recording_properties() -> bool:
	return recording_properties

func set_recording_properties(value: bool) -> void:
	recording_properties = value

