extends GraphElement
class_name GraphFrame

## GraphFrame is a special [GraphElement] that can be used to organize other [GraphElement]s inside a [GraphEdit].
##
## GraphFrame is a special [GraphElement] to which other [GraphElement]s can be attached. It can be configured to automatically resize to enclose all attached [GraphElement]s. If the frame is moved, all the attached [GraphElement]s inside it will be moved as well.
## A GraphFrame is always kept behind the connection layer and other [GraphElement]s inside a [GraphEdit].


## Emitted when [member autoshrink_enabled] or [member autoshrink_margin] changes.
signal autoshrink_changed

## If [code]true[/code], the frame's rect will be adjusted automatically to enclose all attached [GraphElement]s.
var autoshrink_enabled: bool:
	get = is_autoshrink_enabled, set = set_autoshrink_enabled

## The margin around the attached nodes that is used to calculate the size of the frame when [member autoshrink_enabled] is [code]true[/code].
var autoshrink_margin: int:
	get = get_autoshrink_margin, set = set_autoshrink_margin

## The margin inside the frame that can be used to drag the frame.
var drag_margin: int:
	get = get_drag_margin, set = set_drag_margin

var mouse_filter: int:
	get = get_mouse_filter, set = set_mouse_filter

## The color of the frame when [member tint_color_enabled] is [code]true[/code].
var tint_color: Color:
	get = get_tint_color, set = set_tint_color

## If [code]true[/code], the tint color will be used to tint the frame.
var tint_color_enabled: bool:
	get = is_tint_color_enabled, set = set_tint_color_enabled

## Title of the frame.
var title: String:
	get = get_title, set = set_title



## Returns the [HBoxContainer] used for the title bar, only containing a [Label] for displaying the title by default.
## This can be used to add custom controls to the title bar such as option or close buttons.
func get_titlebar_hbox() -> HBoxContainer:
	pass;


func is_autoshrink_enabled() -> bool:
	return autoshrink_enabled

func set_autoshrink_enabled(value: bool) -> void:
	autoshrink_enabled = value

func get_autoshrink_margin() -> int:
	return autoshrink_margin

func set_autoshrink_margin(value: int) -> void:
	autoshrink_margin = value

func get_drag_margin() -> int:
	return drag_margin

func set_drag_margin(value: int) -> void:
	drag_margin = value

func get_mouse_filter() -> int:
	return mouse_filter

func set_mouse_filter(value: int) -> void:
	mouse_filter = value

func get_tint_color() -> Color:
	return tint_color

func set_tint_color(value: Color) -> void:
	tint_color = value

func is_tint_color_enabled() -> bool:
	return tint_color_enabled

func set_tint_color_enabled(value: bool) -> void:
	tint_color_enabled = value

func get_title() -> String:
	return title

func set_title(value: String) -> void:
	title = value

