extends Resource
class_name GLTFPhysicsShape

## Represents a glTF physics shape.
##
## Represents a physics shape as defined by the [code]OMI_physics_shape[/code] or [code]OMI_collider[/code] glTF extensions. This class is an intermediary between the glTF data and Godot's nodes, and it's abstracted in a way that allows adding support for different glTF physics extensions in the future.
##
## @tutorial(Runtime file loading and saving): https://docs.godotengine.org/en/stable/tutorials/io/runtime_file_loading_and_saving.html
## @tutorial(OMI_physics_shape glTF extension): https://github.com/omigroup/gltf-extensions/tree/main/extensions/2.0/OMI_physics_shape
## @tutorial(OMI_collider glTF extension): https://github.com/omigroup/gltf-extensions/tree/main/extensions/2.0/Archived/OMI_collider



## The height of the shape, in meters. This is only used when the shape type is "capsule" or "cylinder". This value should not be negative, and for "capsule" it should be at least twice the radius.
var height: float:
	get = get_height, set = set_height

## The [ImporterMesh] resource of the shape. This is only used when the shape type is "hull" (convex hull) or "trimesh" (concave trimesh).
var importer_mesh: ImporterMesh:
	get = get_importer_mesh, set = set_importer_mesh

## If [code]true[/code], indicates that this shape is a trigger. For Godot, this means that the shape should be a child of an Area3D node.
## This is the only variable not used in the [method to_node] method, it's intended to be used alongside when deciding where to add the generated node as a child.
var is_trigger: bool:
	get = get_is_trigger, set = set_is_trigger

## The index of the shape's mesh in the glTF file. This is only used when the shape type is "hull" (convex hull) or "trimesh" (concave trimesh).
var mesh_index: int:
	get = get_mesh_index, set = set_mesh_index

## The radius of the shape, in meters. This is only used when the shape type is "capsule", "cylinder", or "sphere". This value should not be negative.
var radius: float:
	get = get_radius, set = set_radius

## The type of shape this shape represents. Valid values are "box", "capsule", "cylinder", "sphere", "hull", and "trimesh".
var shape_type: String:
	get = get_shape_type, set = set_shape_type

## The size of the shape, in meters. This is only used when the shape type is "box", and it represents the "diameter" of the box. This value should not be negative.
var size: Vector3:
	get = get_size, set = set_size



## Creates a new GLTFPhysicsShape instance by parsing the given [Dictionary].
static func from_dictionary(dictionary: Dictionary) -> GLTFPhysicsShape:
	pass;

## Creates a new GLTFPhysicsShape instance from the given Godot [CollisionShape3D] node.
static func from_node(shape_node: CollisionShape3D) -> GLTFPhysicsShape:
	pass;

## Creates a new GLTFPhysicsShape instance from the given Godot [Shape3D] resource.
static func from_resource(shape_resource: Shape3D) -> GLTFPhysicsShape:
	pass;

## Serializes this GLTFPhysicsShape instance into a [Dictionary] in the format defined by [code]OMI_physics_shape[/code].
func to_dictionary() -> Dictionary:
	pass;

## Converts this GLTFPhysicsShape instance into a Godot [CollisionShape3D] node.
func to_node(cache_shapes: bool = false) -> CollisionShape3D:
	pass;

## Converts this GLTFPhysicsShape instance into a Godot [Shape3D] resource.
func to_resource(cache_shapes: bool = false) -> Shape3D:
	pass;


func get_height() -> float:
	return height

func set_height(value: float) -> void:
	height = value

func get_importer_mesh() -> ImporterMesh:
	return importer_mesh

func set_importer_mesh(value: ImporterMesh) -> void:
	importer_mesh = value

func get_is_trigger() -> bool:
	return is_trigger

func set_is_trigger(value: bool) -> void:
	is_trigger = value

func get_mesh_index() -> int:
	return mesh_index

func set_mesh_index(value: int) -> void:
	mesh_index = value

func get_radius() -> float:
	return radius

func set_radius(value: float) -> void:
	radius = value

func get_shape_type() -> String:
	return shape_type

func set_shape_type(value: String) -> void:
	shape_type = value

func get_size() -> Vector3:
	return size

func set_size(value: Vector3) -> void:
	size = value

