extends GLTFState
class_name FBXState

## The FBXState handles the state data imported from FBX files.



## If [code]true[/code], the import process used auxiliary nodes called geometry helper nodes. These nodes help preserve the pivots and transformations of the original 3D model during import.
var allow_geometry_helper_nodes: bool:
	get = get_allow_geometry_helper_nodes, set = set_allow_geometry_helper_nodes




func get_allow_geometry_helper_nodes() -> bool:
	return allow_geometry_helper_nodes

func set_allow_geometry_helper_nodes(value: bool) -> void:
	allow_geometry_helper_nodes = value

