extends HBoxContainer
class_name EditorToaster

## Manages toast notifications within the editor.
##
## This object manages the functionality and display of toast notifications within the editor, ensuring timely and informative alerts are presented to users.
## [b]Note:[/b] This class shouldn't be instantiated directly. Instead, access the singleton using [method EditorInterface.get_editor_toaster].


## Toast will display with an INFO severity.
## Toast will display with a WARNING severity and have a corresponding color.
## Toast will display with an ERROR severity and have a corresponding color.

#enum Severity
enum {
    SEVERITY_INFO = 0,
    SEVERITY_WARNING = 1,
    SEVERITY_ERROR = 2,
}


## Pushes a toast notification to the editor for display.
func push_toast(message: String, severity: int = 0, tooltip: String = "") -> void:
	pass;


