extends RefCounted
class_name EditorInspectorPlugin

## Plugin for adding custom property editors on the inspector.
##
## [EditorInspectorPlugin] allows adding custom property editors to [EditorInspector].
## When an object is edited, the [method _can_handle] function is called and must return [code]true[/code] if the object type is supported.
## If supported, the function [method _parse_begin] will be called, allowing to place custom controls at the beginning of the class.
## Subsequently, the [method _parse_category] and [method _parse_property] are called for every category and property. They offer the ability to add custom controls to the inspector too.
## Finally, [method _parse_end] will be called.
## On each of these calls, the "add" functions can be called.
## To use [EditorInspectorPlugin], register it using the [method EditorPlugin.add_inspector_plugin] method first.
##
## @tutorial(Inspector plugins): https://docs.godotengine.org/en/stable/tutorials/plugins/editor/inspector_plugins.html





## Returns [code]true[/code] if this object can be handled by this plugin.
func _can_handle(object: Object) -> bool:
	pass;

## Called to allow adding controls at the beginning of the property list for [param object].
func _parse_begin(object: Object) -> void:
	pass;

## Called to allow adding controls at the beginning of a category in the property list for [param object].
func _parse_category(object: Object, category: String) -> void:
	pass;

## Called to allow adding controls at the end of the property list for [param object].
func _parse_end(object: Object) -> void:
	pass;

## Called to allow adding controls at the beginning of a group or a sub-group in the property list for [param object].
func _parse_group(object: Object, group: String) -> void:
	pass;

## Called to allow adding property-specific editors to the property list for [param object]. The added editor control must extend [EditorProperty]. Returning [code]true[/code] removes the built-in editor for this property, otherwise allows to insert a custom editor before the built-in one.
func _parse_property(object: Object, type: int, name: String, hint_type: int, hint_string: String, usage_flags: int, wide: bool) -> bool:
	pass;

## Adds a custom control, which is not necessarily a property editor.
func add_custom_control(control: Control) -> void:
	pass;

## Adds a property editor for an individual property. The [param editor] control must extend [EditorProperty].
## There can be multiple property editors for a property. If [param add_to_end] is [code]true[/code], this newly added editor will be displayed after all the other editors of the property whose [param add_to_end] is [code]false[/code]. For example, the editor uses this parameter to add an "Edit Region" button for [member Sprite2D.region_rect] below the regular [Rect2] editor.
## [param label] can be used to choose a custom label for the property editor in the inspector. If left empty, the label is computed from the name of the property instead.
func add_property_editor(property: String, editor: Control, add_to_end: bool = false, label: String = "") -> void:
	pass;

## Adds an editor that allows modifying multiple properties. The [param editor] control must extend [EditorProperty].
func add_property_editor_for_multiple_properties(label: String, properties: PackedStringArray, editor: Control) -> void:
	pass;


