extends RefCounted
class_name Crypto

## Provides access to advanced cryptographic functionalities.
##
## The Crypto class provides access to advanced cryptographic functionalities.
## Currently, this includes asymmetric key encryption/decryption, signing/verification, and generating cryptographically secure random bytes, RSA keys, HMAC digests, and self-signed [X509Certificate]s.
## [codeblocks]
## [gdscript]
## var crypto = Crypto.new()
## # Generate new RSA key.
## var key = crypto.generate_rsa(4096)
## # Generate new self-signed certificate with the given key.
## var cert = crypto.generate_self_signed_certificate(key, "CN=mydomain.com,O=My Game Company,C=IT")
## # Save key and certificate in the user folder.
## key.save("user://generated.key")
## cert.save("user://generated.crt")
## # Encryption
## var data = "Some data"
## var encrypted = crypto.encrypt(key, data.to_utf8_buffer())
## # Decryption
## var decrypted = crypto.decrypt(key, encrypted)
## # Signing
## var signature = crypto.sign(HashingContext.HASH_SHA256, data.sha256_buffer(), key)
## # Verifying
## var verified = crypto.verify(HashingContext.HASH_SHA256, data.sha256_buffer(), signature, key)
## # Checks
## assert(verified)
## assert(data.to_utf8_buffer() == decrypted)
## [/gdscript]
## [csharp]
## using Godot;
## using System.Diagnostics;
## Crypto crypto = new Crypto();
## // Generate new RSA key.
## CryptoKey key = crypto.GenerateRsa(4096);
## // Generate new self-signed certificate with the given key.
## X509Certificate cert = crypto.GenerateSelfSignedCertificate(key, "CN=mydomain.com,O=My Game Company,C=IT");
## // Save key and certificate in the user folder.
## key.Save("user://generated.key");
## cert.Save("user://generated.crt");
## // Encryption
## string data = "Some data";
## byte[] encrypted = crypto.Encrypt(key, data.ToUtf8Buffer());
## // Decryption
## byte[] decrypted = crypto.Decrypt(key, encrypted);
## // Signing
## byte[] signature = crypto.Sign(HashingContext.HashType.Sha256, Data.Sha256Buffer(), key);
## // Verifying
## bool verified = crypto.Verify(HashingContext.HashType.Sha256, Data.Sha256Buffer(), signature, key);
## // Checks
## Debug.Assert(verified);
## Debug.Assert(data.ToUtf8Buffer() == decrypted);
## [/csharp]
## [/codeblocks]





## Compares two [PackedByteArray]s for equality without leaking timing information in order to prevent timing attacks.
## See [url=https://paragonie.com/blog/2015/11/preventing-timing-attacks-on-string-comparison-with-double-hmac-strategy]this blog post[/url] for more information.
func constant_time_compare(trusted: PackedByteArray, received: PackedByteArray) -> bool:
	pass;

## Decrypt the given [param ciphertext] with the provided private [param key].
## [b]Note:[/b] The maximum size of accepted ciphertext is limited by the key size.
func decrypt(key: CryptoKey, ciphertext: PackedByteArray) -> PackedByteArray:
	pass;

## Encrypt the given [param plaintext] with the provided public [param key].
## [b]Note:[/b] The maximum size of accepted plaintext is limited by the key size.
func encrypt(key: CryptoKey, plaintext: PackedByteArray) -> PackedByteArray:
	pass;

## Generates a [PackedByteArray] of cryptographically secure random bytes with given [param size].
func generate_random_bytes(size: int) -> PackedByteArray:
	pass;

## Generates an RSA [CryptoKey] that can be used for creating self-signed certificates and passed to [method StreamPeerTLS.accept_stream].
func generate_rsa(size: int) -> CryptoKey:
	pass;

## Generates a self-signed [X509Certificate] from the given [CryptoKey] and [param issuer_name]. The certificate validity will be defined by [param not_before] and [param not_after] (first valid date and last valid date). The [param issuer_name] must contain at least "CN=" (common name, i.e. the domain name), "O=" (organization, i.e. your company name), "C=" (country, i.e. 2 lettered ISO-3166 code of the country the organization is based in).
## A small example to generate an RSA key and an X509 self-signed certificate.
## [codeblocks]
## [gdscript]
## var crypto = Crypto.new()
## # Generate 4096 bits RSA key.
## var key = crypto.generate_rsa(4096)
## # Generate self-signed certificate using the given key.
## var cert = crypto.generate_self_signed_certificate(key, "CN=example.com,O=A Game Company,C=IT")
## [/gdscript]
## [csharp]
## var crypto = new Crypto();
## // Generate 4096 bits RSA key.
## CryptoKey key = crypto.GenerateRsa(4096);
## // Generate self-signed certificate using the given key.
## X509Certificate cert = crypto.GenerateSelfSignedCertificate(key, "CN=mydomain.com,O=My Game Company,C=IT");
## [/csharp]
## [/codeblocks]
func generate_self_signed_certificate(key: CryptoKey, issuer_name: String = "CN=myserver,O=myorganisation,C=IT", not_before: String = "20140101000000", not_after: String = "20340101000000") -> X509Certificate:
	pass;

## Generates an [url=https://en.wikipedia.org/wiki/HMAC]HMAC[/url] digest of [param msg] using [param key]. The [param hash_type] parameter is the hashing algorithm that is used for the inner and outer hashes.
## Currently, only [constant HashingContext.HASH_SHA256] and [constant HashingContext.HASH_SHA1] are supported.
func hmac_digest(hash_type: int, key: PackedByteArray, msg: PackedByteArray) -> PackedByteArray:
	pass;

## Sign a given [param hash] of type [param hash_type] with the provided private [param key].
func sign(hash_type: int, hash: PackedByteArray, key: CryptoKey) -> PackedByteArray:
	pass;

## Verify that a given [param signature] for [param hash] of type [param hash_type] against the provided public [param key].
func verify(hash_type: int, hash: PackedByteArray, signature: PackedByteArray, key: CryptoKey) -> bool:
	pass;


