extends Node3D
class_name CollisionShape3D

## A node that provides a [Shape3D] to a [CollisionObject3D] parent.
##
## A node that provides a [Shape3D] to a [CollisionObject3D] parent and allows to edit it. This can give a detection shape to an [Area3D] or turn a [PhysicsBody3D] into a solid object.
## [b]Warning:[/b] A non-uniformly scaled [CollisionShape3D] will likely not behave as expected. Make sure to keep its scale the same on all axes and adjust its [member shape] resource instead.
##
## @tutorial(Physics introduction): https://docs.godotengine.org/en/stable/tutorials/physics/physics_introduction.html
## @tutorial(3D Kinematic Character Demo): https://godotengine.org/asset-library/asset/2739
## @tutorial(3D Platformer Demo): https://godotengine.org/asset-library/asset/2748
## @tutorial(Third Person Shooter (TPS) Demo): https://godotengine.org/asset-library/asset/2710



## The collision shape color that is displayed in the editor, or in the running project if [b]Debug > Visible Collision Shapes[/b] is checked at the top of the editor.
## [b]Note:[/b] The default value is [member ProjectSettings.debug/shapes/collision/shape_color]. The [code]Color(0, 0, 0, 0)[/code] value documented here is a placeholder, and not the actual default debug color.
var debug_color: Color:
	get = get_debug_color, set = set_debug_color

## If [code]true[/code], when the shape is displayed, it will show a solid fill color in addition to its wireframe.
var debug_fill: bool:
	get = get_enable_debug_fill, set = set_enable_debug_fill

## A disabled collision shape has no effect in the world.
var disabled: bool:
	get = is_disabled, set = set_disabled

## The actual shape owned by this collision shape.
var shape: Shape3D:
	get = get_shape, set = set_shape



## Sets the collision shape's shape to the addition of all its convexed [MeshInstance3D] siblings geometry.
func make_convex_from_siblings() -> void:
	pass;

## This method does nothing.
func resource_changed(resource: Resource) -> void:
	pass;


func get_debug_color() -> Color:
	return debug_color

func set_debug_color(value: Color) -> void:
	debug_color = value

func get_enable_debug_fill() -> bool:
	return debug_fill

func set_enable_debug_fill(value: bool) -> void:
	debug_fill = value

func is_disabled() -> bool:
	return disabled

func set_disabled(value: bool) -> void:
	disabled = value

func get_shape() -> Shape3D:
	return shape

func set_shape(value: Shape3D) -> void:
	shape = value

