extends Node2D
class_name CollisionPolygon2D

## A node that provides a polygon shape to a [CollisionObject2D] parent.
##
## A node that provides a polygon shape to a [CollisionObject2D] parent and allows to edit it. The polygon can be concave or convex. This can give a detection shape to an [Area2D], turn [PhysicsBody2D] into a solid object, or give a hollow shape to a [StaticBody2D].
## [b]Warning:[/b] A non-uniformly scaled [CollisionPolygon2D] will likely not behave as expected. Make sure to keep its scale the same on all axes and adjust its polygon instead.


## Collisions will include the polygon and its contained area. In this mode the node has the same effect as several [ConvexPolygonShape2D] nodes, one for each convex shape in the convex decomposition of the polygon (but without the overhead of multiple nodes).
## Collisions will only include the polygon edges. In this mode the node has the same effect as a single [ConcavePolygonShape2D] made of segments, with the restriction that each segment (after the first one) starts where the previous one ends, and the last one ends where the first one starts (forming a closed but hollow polygon).

#enum BuildMode
enum {
    BUILD_SOLIDS = 0,
    BUILD_SEGMENTS = 1,
}
## Collision build mode. Use one of the [enum BuildMode] constants.
var build_mode: int:
	get = get_build_mode, set = set_build_mode

## If [code]true[/code], no collisions will be detected.
var disabled: bool:
	get = is_disabled, set = set_disabled

## If [code]true[/code], only edges that face up, relative to [CollisionPolygon2D]'s rotation, will collide with other objects.
## [b]Note:[/b] This property has no effect if this [CollisionPolygon2D] is a child of an [Area2D] node.
var one_way_collision: bool:
	get = is_one_way_collision_enabled, set = set_one_way_collision

## The margin used for one-way collision (in pixels). Higher values will make the shape thicker, and work better for colliders that enter the polygon at a high velocity.
var one_way_collision_margin: float:
	get = get_one_way_collision_margin, set = set_one_way_collision_margin

## The polygon's list of vertices. Each point will be connected to the next, and the final point will be connected to the first.
## [b]Note:[/b] The returned vertices are in the local coordinate space of the given [CollisionPolygon2D].
var polygon: PackedVector2Array:
	get = get_polygon, set = set_polygon




func get_build_mode() -> int:
	return build_mode

func set_build_mode(value: int) -> void:
	build_mode = value

func is_disabled() -> bool:
	return disabled

func set_disabled(value: bool) -> void:
	disabled = value

func is_one_way_collision_enabled() -> bool:
	return one_way_collision

func set_one_way_collision(value: bool) -> void:
	one_way_collision = value

func get_one_way_collision_margin() -> float:
	return one_way_collision_margin

func set_one_way_collision_margin(value: float) -> void:
	one_way_collision_margin = value

func get_polygon() -> PackedVector2Array:
	return polygon

func set_polygon(value: PackedVector2Array) -> void:
	polygon = value

