extends Node2D
class_name CanvasModulate

## A node that applies a color tint to a canvas.
##
## [CanvasModulate] applies a color tint to all nodes on a canvas. Only one can be used to tint a canvas, but [CanvasLayer]s can be used to render things independently.
##
## @tutorial(2D lights and shadows): https://docs.godotengine.org/en/stable/tutorials/2d/2d_lights_and_shadows.html



## The tint color to apply.
var color: Color:
	get = get_color, set = set_color




func get_color() -> Color:
	return color

func set_color(value: Color) -> void:
	color = value

