extends Shape3D
class_name BoxShape3D

## A 3D box shape used for physics collision.
##
## A 3D box shape, intended for use in physics. Usually used to provide a shape for a [CollisionShape3D].
## [b]Performance:[/b] [BoxShape3D] is fast to check collisions against. It is faster than [CapsuleShape3D] and [CylinderShape3D], but slower than [SphereShape3D].
##
## @tutorial(3D Physics Tests Demo): https://godotengine.org/asset-library/asset/2747
## @tutorial(3D Kinematic Character Demo): https://godotengine.org/asset-library/asset/2739
## @tutorial(3D Platformer Demo): https://godotengine.org/asset-library/asset/2748



## The box's width, height and depth.
var size: Vector3:
	get = get_size, set = set_size




func get_size() -> Vector3:
	return size

func set_size(value: Vector3) -> void:
	size = value

