extends Node3D
class_name BoneAttachment3D

## А node that dynamically copies or overrides the 3D transform of a bone in its parent [Skeleton3D].
##
## This node selects a bone in a [Skeleton3D] and attaches to it. This means that the [BoneAttachment3D] node will either dynamically copy or override the 3D transform of the selected bone.



## The index of the attached bone.
var bone_idx: int:
	get = get_bone_idx, set = set_bone_idx

## The name of the attached bone.
var bone_name: String:
	get = get_bone_name, set = set_bone_name

## Whether the BoneAttachment3D node will override the bone pose of the bone it is attached to. When set to [code]true[/code], the BoneAttachment3D node can change the pose of the bone. When set to [code]false[/code], the BoneAttachment3D will always be set to the bone's transform.
## [b]Note:[/b] This override performs interruptively in the skeleton update process using signals due to the old design. It may cause unintended behavior when used at the same time with [SkeletonModifier3D].
var override_pose: bool:
	get = get_override_pose, set = set_override_pose



## Returns the [NodePath] to the external [Skeleton3D] node, if one has been set.
func get_external_skeleton() -> NodePath:
	pass;

## Get parent or external [Skeleton3D] node if found.
func get_skeleton() -> Skeleton3D:
	pass;

## Returns whether the BoneAttachment3D node is using an external [Skeleton3D] rather than attempting to use its parent node as the [Skeleton3D].
func get_use_external_skeleton() -> bool:
	pass;

## A function that is called automatically when the [Skeleton3D] is updated. This function is where the [BoneAttachment3D] node updates its position so it is correctly bound when it is [i]not[/i] set to override the bone pose.
func on_skeleton_update() -> void:
	pass;

## Sets the [NodePath] to the external skeleton that the BoneAttachment3D node should use. See [method set_use_external_skeleton] to enable the external [Skeleton3D] node.
func set_external_skeleton(external_skeleton: NodePath) -> void:
	pass;

## Sets whether the BoneAttachment3D node will use an external [Skeleton3D] node rather than attempting to use its parent node as the [Skeleton3D]. When set to [code]true[/code], the BoneAttachment3D node will use the external [Skeleton3D] node set in [method set_external_skeleton].
func set_use_external_skeleton(use_external_skeleton: bool) -> void:
	pass;


func get_bone_idx() -> int:
	return bone_idx

func set_bone_idx(value: int) -> void:
	bone_idx = value

func get_bone_name() -> String:
	return bone_name

func set_bone_name(value: String) -> void:
	bone_name = value

func get_override_pose() -> bool:
	return override_pose

func set_override_pose(value: bool) -> void:
	override_pose = value

