extends AudioStream
class_name AudioStreamPlaylist

## [AudioStream] that includes sub-streams and plays them back like a playlist.


## Maximum amount of streams supported in the playlist.
const MAX_STREAMS = 64;


## Fade time used when a stream ends, when going to the next one. Streams are expected to have an extra bit of audio after the end to help with fading.
var fade_time: float:
	get = get_fade_time, set = set_fade_time

## If [code]true[/code], the playlist will loop, otherwise the playlist will end when the last stream is finished.
var loop: bool:
	get = has_loop, set = set_loop

## If [code]true[/code], the playlist will shuffle each time playback starts and each time it loops.
var shuffle: bool:
	get = get_shuffle, set = set_shuffle

## Amount of streams in the playlist.
var stream_count: int:
	get = get_stream_count, set = set_stream_count



## Returns the BPM of the playlist, which can vary depending on the clip being played.
func get_bpm() -> float:
	pass;

## Returns the stream at playback position index.
func get_list_stream(stream_index: int) -> AudioStream:
	pass;

## Sets the stream at playback position index.
func set_list_stream(stream_index: int, audio_stream: AudioStream) -> void:
	pass;


func get_fade_time() -> float:
	return fade_time

func set_fade_time(value: float) -> void:
	fade_time = value

func has_loop() -> bool:
	return loop

func set_loop(value: bool) -> void:
	loop = value

func get_shuffle() -> bool:
	return shuffle

func set_shuffle(value: bool) -> void:
	shuffle = value

func get_stream_count() -> int:
	return stream_count

func set_stream_count(value: int) -> void:
	stream_count = value

