extends AudioStream
class_name AudioStreamOggVorbis

## A class representing an Ogg Vorbis audio stream.
##
## The AudioStreamOggVorbis class is a specialized [AudioStream] for handling Ogg Vorbis file formats. It offers functionality for loading and playing back Ogg Vorbis files, as well as managing looping and other playback properties. This class is part of the audio stream system, which also supports WAV files through the [AudioStreamWAV] class.
##
## @tutorial(Runtime file loading and saving): https://docs.godotengine.org/en/stable/tutorials/io/runtime_file_loading_and_saving.html



var bar_beats: int:
	get = get_bar_beats, set = set_bar_beats

var beat_count: int:
	get = get_beat_count, set = set_beat_count

var bpm: float:
	get = get_bpm, set = set_bpm

## If [code]true[/code], the audio will play again from the specified [member loop_offset] once it is done playing. Useful for ambient sounds and background music.
var loop: bool:
	get = has_loop, set = set_loop

## Time in seconds at which the stream starts after being looped.
var loop_offset: float:
	get = get_loop_offset, set = set_loop_offset

## Contains the raw Ogg data for this stream.
var packet_sequence: OggPacketSequence:
	get = get_packet_sequence, set = set_packet_sequence



## Creates a new [AudioStreamOggVorbis] instance from the given buffer. The buffer must contain Ogg Vorbis data.
static func load_from_buffer(stream_data: PackedByteArray) -> AudioStreamOggVorbis:
	pass;

## Creates a new [AudioStreamOggVorbis] instance from the given file path. The file must be in Ogg Vorbis format.
static func load_from_file(path: String) -> AudioStreamOggVorbis:
	pass;


func get_bar_beats() -> int:
	return bar_beats

func set_bar_beats(value: int) -> void:
	bar_beats = value

func get_beat_count() -> int:
	return beat_count

func set_beat_count(value: int) -> void:
	beat_count = value

func get_bpm() -> float:
	return bpm

func set_bpm(value: float) -> void:
	bpm = value

func has_loop() -> bool:
	return loop

func set_loop(value: bool) -> void:
	loop = value

func get_loop_offset() -> float:
	return loop_offset

func set_loop_offset(value: float) -> void:
	loop_offset = value

func get_packet_sequence() -> OggPacketSequence:
	return packet_sequence

func set_packet_sequence(value: OggPacketSequence) -> void:
	packet_sequence = value

