extends AudioEffectInstance
class_name AudioEffectSpectrumAnalyzerInstance

## Queryable instance of an [AudioEffectSpectrumAnalyzer].
##
## The runtime part of an [AudioEffectSpectrumAnalyzer], which can be used to query the magnitude of a frequency range on its host bus.
## An instance of this class can be obtained with [method AudioServer.get_bus_effect_instance].
##
## @tutorial(Audio Spectrum Visualizer Demo): https://godotengine.org/asset-library/asset/2762


## Use the average value across the frequency range as magnitude.
## Use the maximum value of the frequency range as magnitude.

#enum MagnitudeMode
enum {
    MAGNITUDE_AVERAGE = 0,
    MAGNITUDE_MAX = 1,
}


## Returns the magnitude of the frequencies from [param from_hz] to [param to_hz] in linear energy as a Vector2. The [code]x[/code] component of the return value represents the left stereo channel, and [code]y[/code] represents the right channel.
## [param mode] determines how the frequency range will be processed. See [enum MagnitudeMode].
func get_magnitude_for_frequency_range(from_hz: float, to_hz: float, mode: int = 1) -> Vector2:
	pass;


