extends AnimationNode
class_name AnimationNodeSync

## Base class for [AnimationNode]s with multiple input ports that must be synchronized.
##
## An animation node used to combine, mix, or blend two or more animations together while keeping them synchronized within an [AnimationTree].
##
## @tutorial(Using AnimationTree): https://docs.godotengine.org/en/stable/tutorials/animation/animation_tree.html



## If [code]false[/code], the blended animations' frame are stopped when the blend value is [code]0[/code].
## If [code]true[/code], forcing the blended animations to advance frame.
var sync: bool:
	get = is_using_sync, set = set_use_sync




func is_using_sync() -> bool:
	return sync

func set_use_sync(value: bool) -> void:
	sync = value

