extends AnimationNode
class_name AnimationNodeExtension

## Base class for extending [AnimationRootNode]s from GDScript, C#, or C++.
##
## [AnimationNodeExtension] exposes the APIs of [AnimationRootNode] to allow users to extend it from GDScript, C#, or C++. This class is not meant to be used directly, but to be extended by other classes. It is used to create custom nodes for the [AnimationTree] system.





## A version of the [method AnimationNode._process] method that is meant to be overridden by custom nodes. It returns a [PackedFloat32Array] with the processed animation data.
## The [PackedFloat64Array] parameter contains the playback information, containing the following values encoded as floating point numbers (in order): playback time and delta, start and end times, whether a seek was requested (encoded as a float greater than [code]0[/code]), whether the seek request was externally requested (encoded as a float greater than [code]0[/code]), the current [enum Animation.LoopedFlag] (encoded as a float), and the current blend weight.
## The function must return a [PackedFloat32Array] of the node's time info, containing the following values (in order): animation length, time position, delta, [enum Animation.LoopMode] (encoded as a float), whether the animation is about to end (encoded as a float greater than [code]0[/code]) and whether the animation is infinite (encoded as a float greater than [code]0[/code]). All values must be included in the returned array.
func _process_animation_node(playback_info: PackedFloat64Array, test_only: bool) -> PackedFloat32Array:
	pass;

## Returns the animation's remaining time for the given node info. For looping animations, it will only return the remaining time if [param break_loop] is [code]true[/code], a large integer value will be returned otherwise.
static func get_remaining_time(node_info: PackedFloat32Array, break_loop: bool) -> float:
	pass;

## Returns [code]true[/code] if the animation for the given [param node_info] is looping.
static func is_looping(node_info: PackedFloat32Array) -> bool:
	pass;


