extends XRPositionalTracker
class_name XRControllerTracker

## A tracked controller.
##
## An instance of this object represents a controller that is tracked.
## As controllers are turned on and the [XRInterface] detects them, instances of this object are automatically added to this list of active tracking objects accessible through the [XRServer].
## The [XRController3D] consumes objects of this type and should be used in your project.
##
## @tutorial(XR documentation index): https://docs.godotengine.org/en/stable/tutorials/xr/index.html



var type: int:
	get = get_tracker_type, set = set_tracker_type




func get_tracker_type() -> int:
	return type

func set_tracker_type(value: int) -> void:
	type = value

